/*
 * Decompiled with CFR 0.152.
 */
package me.piruin.quickaction;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.StyleRes;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.piruin.quickaction.ActionItem;
import me.piruin.quickaction.ArrowDrawable;
import me.piruin.quickaction.PopupWindows;
import me.piruin.quickaction.R;

public class QuickAction
extends PopupWindows
implements PopupWindow.OnDismissListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static int defaultColor = -1;
    private static int defaultTextColor = -16777216;
    private static int defaultDividerColor = Color.argb((int)32, (int)0, (int)0, (int)0);
    private final int shadowSize;
    private final int shadowColor;
    private boolean enabledDivider;
    private WindowManager windowManager;
    private View rootView;
    private View arrowUp;
    private View arrowDown;
    private LayoutInflater inflater;
    private Resources resource;
    private LinearLayout track;
    private ViewGroup scroller;
    private OnActionItemClickListener mItemClickListener;
    private OnDismissListener dismissListener;
    private List<ActionItem> actionItems = new ArrayList<ActionItem>();
    private Animation animation = Animation.AUTO;
    private boolean didAction;
    private int orientation;
    private int rootWidth = 0;
    private int dividerColor = defaultDividerColor;
    private int textColor = defaultTextColor;

    public QuickAction(@NonNull Context context) {
        this(context, 1);
    }

    public QuickAction(@NonNull Context context, int orientation) {
        super(context);
        this.orientation = orientation;
        this.inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.windowManager = (WindowManager)context.getSystemService("window");
        this.resource = context.getResources();
        this.shadowSize = this.resource.getDimensionPixelSize(R.dimen.quick_action_shadow_size);
        this.shadowColor = this.resource.getColor(R.color.quick_action_shadow_color);
        this.setRootView(orientation == 1 ? R.layout.quick_action_vertical : R.layout.quick_action_horizontal);
        this.enabledDivider = orientation == 0;
    }

    private void setRootView(@LayoutRes int id2) {
        this.rootView = this.inflater.inflate(id2, null);
        this.rootView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.track = (LinearLayout)this.rootView.findViewById(R.id.tracks);
        this.track.setOrientation(this.orientation);
        this.arrowDown = this.rootView.findViewById(R.id.arrow_down);
        this.arrowUp = this.rootView.findViewById(R.id.arrow_up);
        this.scroller = (ViewGroup)this.rootView.findViewById(R.id.scroller);
        this.setContentView(this.rootView);
        this.setColor(defaultColor);
    }

    public void setColor(@ColorInt int popupColor) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(popupColor);
        drawable.setStroke(this.shadowSize, this.shadowColor);
        drawable.setCornerRadius(this.resource.getDimension(R.dimen.quick_action_corner));
        this.arrowDown.setBackground((Drawable)new ArrowDrawable(2, popupColor, this.shadowSize, this.shadowColor));
        this.arrowUp.setBackground((Drawable)new ArrowDrawable(1, popupColor, this.shadowSize, this.shadowColor));
        this.scroller.setBackground((Drawable)drawable);
    }

    public static void setDefaultTextColor(int defaultTextColor) {
        QuickAction.defaultTextColor = defaultTextColor;
    }

    public static void setDefaultTextColor(Context context, @ColorRes int defaultTextColor) {
        QuickAction.defaultTextColor = context.getResources().getColor(defaultTextColor);
    }

    public static void setDefaultDividerColor(int defaultDividerColor) {
        QuickAction.defaultDividerColor = defaultDividerColor;
    }

    public static void setDefaultDividerColor(Context context, @ColorRes int defaultDividerColor) {
        QuickAction.defaultDividerColor = context.getResources().getColor(defaultDividerColor);
    }

    public static void setDefaultColor(int defaultColor) {
        QuickAction.defaultColor = defaultColor;
    }

    public static void setDefaultColor(Context context, @ColorRes int setDefaultColor) {
        defaultColor = context.getResources().getColor(setDefaultColor);
    }

    public void setColorRes(@ColorRes int popupColor) {
        this.setColor(this.resource.getColor(popupColor));
    }

    public void setTextColorRes(@ColorRes int textColorRes) {
        this.setTextColor(this.resource.getColor(textColorRes));
    }

    public void setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
    }

    public void setDividerColor(int color2) {
        this.dividerColor = color2;
    }

    public void setDividerColorRes(@ColorRes int colorRes) {
        this.dividerColor = this.resource.getColor(colorRes);
    }

    public void setEnabledDivider(boolean enabled) {
        this.enabledDivider = enabled;
    }

    public void setAnimStyle(Animation mAnimStyle) {
        this.animation = mAnimStyle;
    }

    public void setOnActionItemClickListener(OnActionItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public void addActionItem(ActionItem ... actions) {
        for (ActionItem item : actions) {
            this.addActionItem(item);
        }
    }

    public void addActionItem(ActionItem action) {
        int position = this.actionItems.size();
        this.actionItems.add(action);
        this.addActionView(position, this.createViewFrom(action));
    }

    private void addActionView(int position, View actionView) {
        if (this.enabledDivider && position != 0) {
            int separatorPos = (position *= 2) - 1;
            View separator = new View(this.getContext());
            separator.setBackgroundColor(this.dividerColor);
            int width = this.resource.getDimensionPixelOffset(R.dimen.quick_action_separator_width);
            ViewGroup.LayoutParams layoutParams = null;
            switch (this.orientation) {
                case 1: {
                    layoutParams = new ViewGroup.LayoutParams(-1, width);
                    break;
                }
                case 0: {
                    layoutParams = new ViewGroup.LayoutParams(width, -1);
                }
            }
            this.track.addView(separator, separatorPos, layoutParams);
        }
        this.track.addView(actionView, position);
    }

    @NonNull
    private View createViewFrom(final ActionItem action) {
        ImageView actionView;
        if (action.haveTitle()) {
            TextView textView = (TextView)this.inflater.inflate(R.layout.quick_action_item, (ViewGroup)this.track, false);
            textView.setTextColor(this.textColor);
            textView.setText((CharSequence)String.format(" %s ", action.getTitle()));
            if (action.haveIcon()) {
                int iconSize = this.resource.getDimensionPixelOffset(R.dimen.quick_action_icon_size);
                Drawable icon = action.getIconDrawable(this.getContext());
                icon.setBounds(0, 0, iconSize, iconSize);
                if (this.orientation == 0) {
                    textView.setCompoundDrawables(null, icon, null, null);
                } else {
                    textView.setCompoundDrawables(icon, null, null, null);
                }
            }
            actionView = textView;
        } else {
            ImageView imageView = (ImageView)this.inflater.inflate(R.layout.quick_action_image_item, (ViewGroup)this.track, false);
            imageView.setId(action.getActionId());
            imageView.setImageDrawable(action.getIconDrawable(this.getContext()));
            actionView = imageView;
        }
        actionView.setId(action.getActionId());
        actionView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                action.setSelected(true);
                if (QuickAction.this.mItemClickListener != null) {
                    QuickAction.this.mItemClickListener.onItemClick(action);
                }
                if (!action.isSticky()) {
                    QuickAction.this.didAction = true;
                    QuickAction.this.dismiss();
                }
            }
        });
        actionView.setFocusable(true);
        actionView.setClickable(true);
        return actionView;
    }

    public void addActionItem(int position, ActionItem action) {
        this.actionItems.add(position, action);
        this.addActionView(position, this.createViewFrom(action));
    }

    public ActionItem getActionItem(int index) {
        return this.actionItems.get(index);
    }

    public ActionItem remove(int actionId) {
        return this.remove(this.getActionItemById(actionId));
    }

    public ActionItem remove(ActionItem action) {
        int index = this.actionItems.indexOf(action);
        if (index == -1) {
            throw new RuntimeException("Not found action");
        }
        if (!this.enabledDivider) {
            this.track.removeViewAt(index);
        } else {
            int viewPos = index * 2;
            this.track.removeViewAt(viewPos);
            this.track.removeViewAt(index == 0 ? 0 : viewPos - 1);
        }
        return this.actionItems.remove(index);
    }

    @Nullable
    public ActionItem getActionItemById(int actionId) {
        for (ActionItem action : this.actionItems) {
            if (action.getActionId() != actionId) continue;
            return action;
        }
        return null;
    }

    public void show(@NonNull Activity activity, @IdRes int anchorId) {
        this.show(activity.findViewById(anchorId));
    }

    public void show(@NonNull View anchor) {
        int yPos;
        boolean onTop;
        int arrowPos;
        int xPos;
        if (this.getContext() == null) {
            throw new IllegalStateException("Why context is null? It shouldn't be.");
        }
        this.preShow();
        this.didAction = false;
        int[] location = new int[2];
        anchor.getLocationOnScreen(location);
        Rect anchorRect = new Rect(location[0], location[1], location[0] + anchor.getWidth(), location[1] + anchor.getHeight());
        this.rootView.measure(-2, -2);
        int rootHeight = this.rootView.getMeasuredHeight();
        if (this.rootWidth == 0) {
            this.rootWidth = this.rootView.getMeasuredWidth();
        }
        DisplayMetrics displaymetrics = new DisplayMetrics();
        this.windowManager.getDefaultDisplay().getMetrics(displaymetrics);
        int screenWidth = displaymetrics.widthPixels;
        int screenHeight = displaymetrics.heightPixels;
        if (anchorRect.left + this.rootWidth > screenWidth) {
            xPos = anchorRect.left - (this.rootWidth - anchor.getWidth());
            xPos = xPos < 0 ? 0 : xPos;
            arrowPos = anchorRect.centerX() - xPos;
        } else {
            xPos = anchor.getWidth() > this.rootWidth ? anchorRect.centerX() - this.rootWidth / 2 : anchorRect.left;
            arrowPos = anchorRect.centerX() - xPos;
        }
        int dyTop = anchorRect.top;
        int dyBottom = screenHeight - anchorRect.bottom;
        boolean bl = onTop = dyTop > dyBottom;
        if (onTop) {
            if (rootHeight > dyTop) {
                yPos = 15;
                ViewGroup.LayoutParams l = this.scroller.getLayoutParams();
                l.height = dyTop - anchor.getHeight();
            } else {
                yPos = anchorRect.top - rootHeight;
            }
        } else {
            yPos = anchorRect.bottom;
            if (rootHeight > dyBottom) {
                ViewGroup.LayoutParams l = this.scroller.getLayoutParams();
                l.height = dyBottom;
            }
        }
        this.showArrow(onTop ? R.id.arrow_down : R.id.arrow_up, arrowPos);
        this.setAnimationStyle(screenWidth, anchorRect.centerX(), onTop);
        this.mWindow.showAtLocation(anchor, 0, xPos, yPos);
    }

    private void showArrow(@IdRes int whichArrow, int requestedX) {
        View showArrow = whichArrow == R.id.arrow_up ? this.arrowUp : this.arrowDown;
        View hideArrow = whichArrow == R.id.arrow_up ? this.arrowDown : this.arrowUp;
        int arrowWidth = this.arrowUp.getMeasuredWidth();
        showArrow.setVisibility(0);
        ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)showArrow.getLayoutParams();
        param.leftMargin = requestedX - arrowWidth / 2;
        hideArrow.setVisibility(8);
    }

    private void setAnimationStyle(int screenWidth, int requestedX, boolean onTop) {
        int arrowPos = requestedX - this.arrowUp.getMeasuredWidth() / 2;
        switch (this.animation) {
            case AUTO: {
                if (arrowPos <= screenWidth / 4) {
                    this.mWindow.setAnimationStyle(Animation.GROW_FROM_LEFT.get(onTop));
                    break;
                }
                if (arrowPos > screenWidth / 4 && arrowPos < 3 * (screenWidth / 4)) {
                    this.mWindow.setAnimationStyle(Animation.GROW_FROM_CENTER.get(onTop));
                    break;
                }
                this.mWindow.setAnimationStyle(Animation.GROW_FROM_RIGHT.get(onTop));
                break;
            }
            default: {
                this.mWindow.setAnimationStyle(this.animation.get(onTop));
            }
        }
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.setOnDismissListener(this);
        this.dismissListener = listener;
    }

    public void onDismiss() {
        if (!this.didAction && this.dismissListener != null) {
            this.dismissListener.onDismiss();
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnActionItemClickListener {
        public void onItemClick(ActionItem var1);
    }

    public static enum Animation {
        GROW_FROM_LEFT{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Left : R.style.Animation_PopDownMenu_Left;
            }
        }
        ,
        GROW_FROM_RIGHT{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Right : R.style.Animation_PopDownMenu_Right;
            }
        }
        ,
        GROW_FROM_CENTER{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Center : R.style.Animation_PopDownMenu_Center;
            }
        }
        ,
        REFLECT{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Reflect : R.style.Animation_PopDownMenu_Reflect;
            }
        }
        ,
        AUTO{

            @Override
            int get(boolean onTop) {
                throw new UnsupportedOperationException("Can't use this");
            }
        };


        @StyleRes
        abstract int get(boolean var1);
    }
}

