/*
 * Decompiled with CFR 0.152.
 */
package me.piruin.quickaction;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.text.TextUtils;

public class ActionItem {
    private Bitmap thumb;
    private String title;
    private int icon = -1;
    private Drawable iconDrawable;
    private int actionId = -1;
    private boolean selected;
    private boolean sticky;

    public ActionItem(int actionId, String title) {
        this(actionId, title, -1);
    }

    public ActionItem(int actionId, String title, @DrawableRes int icon) {
        this.actionId = actionId;
        this.title = title;
        this.icon = icon;
    }

    public ActionItem(@DrawableRes int icon) {
        this(-1, null, icon);
    }

    public ActionItem(int actionId, @DrawableRes int icon) {
        this(actionId, null, icon);
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean haveTitle() {
        return !TextUtils.isEmpty((CharSequence)this.title);
    }

    public void setIcon(@DrawableRes int icon) {
        this.icon = icon;
    }

    @DrawableRes
    public int getIcon() {
        return this.icon;
    }

    public boolean haveIcon() {
        return this.icon > 0 || this.iconDrawable != null;
    }

    public void setActionId(int actionId) {
        this.actionId = actionId;
    }

    public int getActionId() {
        return this.actionId;
    }

    public void setSticky(boolean sticky) {
        this.sticky = sticky;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setThumb(Bitmap thumb) {
        this.thumb = thumb;
    }

    public Bitmap getThumb() {
        return this.thumb;
    }

    public Drawable getIconDrawable(Context context) {
        if (this.iconDrawable == null) {
            this.iconDrawable = context.getResources().getDrawable(this.icon);
        }
        return this.iconDrawable;
    }

    public void setIconDrawable(Drawable iconDrawable) {
        this.iconDrawable = iconDrawable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ActionItem that = (ActionItem)o;
        return this.actionId == that.actionId;
    }

    public int hashCode() {
        return this.actionId;
    }
}

