/*
 * Decompiled with CFR 0.152.
 */
package me.piruin.quickaction;

import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.support.annotation.ColorInt;

final class ArrowDrawable
extends ColorDrawable {
    static final int ARROW_UP = 1;
    static final int ARROW_DOWN = 2;
    private final Paint mPaint = new Paint(1);
    private final Paint mShadowPaint = new Paint(this.mPaint);
    private final int gravity;
    private final int stroke;
    private Path mPath;
    private Path mStrokePath;

    ArrowDrawable(int gravity, @ColorInt int foregroundColor, int strokeWidth, int strokeColor) {
        this.gravity = gravity;
        this.stroke = strokeWidth;
        this.mPaint.setColor(foregroundColor);
        this.mShadowPaint.setColor(strokeColor);
    }

    protected void onBoundsChange(Rect bounds) {
        super.onBoundsChange(bounds);
        this.updatePath(bounds);
        this.updateShadowPath(bounds);
    }

    private synchronized void updatePath(Rect bounds) {
        this.mPath = new Path();
        switch (this.gravity) {
            case 1: {
                this.mPath.moveTo((float)this.stroke, (float)bounds.height());
                this.mPath.lineTo((float)(bounds.width() / 2), (float)this.stroke);
                this.mPath.lineTo((float)(bounds.width() - this.stroke), (float)bounds.height());
                break;
            }
            case 2: {
                this.mPath.moveTo((float)this.stroke, 0.0f);
                this.mPath.lineTo((float)(bounds.width() / 2), (float)(bounds.height() - this.stroke));
                this.mPath.lineTo((float)(bounds.width() - this.stroke), 0.0f);
            }
        }
        this.mPath.close();
    }

    private synchronized void updateShadowPath(Rect bounds) {
        this.mStrokePath = new Path();
        switch (this.gravity) {
            case 1: {
                this.mStrokePath.moveTo(0.0f, (float)bounds.height());
                this.mStrokePath.lineTo((float)(bounds.width() / 2), 0.0f);
                this.mStrokePath.lineTo((float)bounds.width(), (float)bounds.height());
                break;
            }
            case 2: {
                this.mStrokePath.moveTo(0.0f, 0.0f);
                this.mStrokePath.lineTo((float)(bounds.width() / 2), (float)bounds.height());
                this.mStrokePath.lineTo((float)bounds.width(), 0.0f);
            }
        }
        this.mStrokePath.close();
    }

    public void draw(Canvas canvas) {
        canvas.drawColor(0);
        if (this.mPath == null) {
            this.updatePath(this.getBounds());
            this.updateShadowPath(this.getBounds());
        }
        canvas.drawPath(this.mStrokePath, this.mShadowPaint);
        canvas.drawPath(this.mPath, this.mPaint);
    }

    public void setColor(@ColorInt int color) {
        this.mPaint.setColor(color);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mPaint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        if (this.mPaint.getColorFilter() != null) {
            return -3;
        }
        switch (this.mPaint.getColor() >>> 24) {
            case 255: {
                return -1;
            }
            case 0: {
                return -2;
            }
        }
        return -3;
    }
}

