/*
 * Decompiled with CFR 0.152.
 */
package me.piruin.quickaction;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.IdRes;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.StyleRes;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import java.util.ArrayList;
import java.util.List;
import me.piruin.quickaction.ActionItem;
import me.piruin.quickaction.ArrowDrawable;
import me.piruin.quickaction.PopupWindows;
import me.piruin.quickaction.R;

public class QuickAction
extends PopupWindows
implements PopupWindow.OnDismissListener {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private WindowManager mWindowManager;
    private View mRootView;
    private View mArrowUp;
    private View mArrowDown;
    private LayoutInflater mInflater;
    private Resources mResource;
    private LinearLayout mTrack;
    private ViewGroup mScroller;
    private OnActionItemClickListener mItemClickListener;
    private OnDismissListener mDismissListener;
    private List<ActionItem> actionItems = new ArrayList<ActionItem>();
    private boolean mDidAction;
    private int mChildPos = 0;
    private int mInsertPos;
    private Animation mAnimStyle = Animation.AUTO;
    private int mOrientation;
    private int rootWidth = 0;
    private int mTextColor = -16777216;

    public QuickAction(@NonNull Context context) {
        this(context, 1);
    }

    public QuickAction(@NonNull Context context, int orientation) {
        super(context);
        this.mOrientation = orientation;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        this.mResource = context.getResources();
        this.setRootViewId(orientation == 1 ? R.layout.popup : R.layout.popup_horizontal);
    }

    private void setRootViewId(@LayoutRes int id2) {
        this.mRootView = this.mInflater.inflate(id2, null);
        this.mTrack = (LinearLayout)this.mRootView.findViewById(R.id.tracks);
        this.mTrack.setOrientation(this.mOrientation);
        this.mArrowDown = this.mRootView.findViewById(R.id.arrow_down);
        this.mArrowUp = this.mRootView.findViewById(R.id.arrow_up);
        this.mScroller = (ViewGroup)this.mRootView.findViewById(R.id.scroller);
        this.mRootView.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        this.setContentView(this.mRootView);
        this.setColor(-1);
    }

    public void setColor(@ColorInt int popupColor) {
        GradientDrawable drawable = new GradientDrawable();
        drawable.setColor(popupColor);
        drawable.setCornerRadius(this.mResource.getDimension(R.dimen.popup_corner));
        this.mArrowDown.setBackground((Drawable)new ArrowDrawable(popupColor, 2));
        this.mArrowUp.setBackground((Drawable)new ArrowDrawable(popupColor, 1));
        this.mScroller.setBackground((Drawable)drawable);
    }

    public void setColorRes(@ColorRes int popupColor) {
        this.setColor(this.mResource.getColor(popupColor));
    }

    public void setTextColorRes(@ColorRes int textColorRes) {
        this.setTextColor(this.mResource.getColor(textColorRes));
    }

    public void setTextColor(@ColorInt int textColor) {
        this.mTextColor = textColor;
    }

    public void setAnimStyle(Animation mAnimStyle) {
        this.mAnimStyle = mAnimStyle;
    }

    public void setOnActionItemClickListener(OnActionItemClickListener listener) {
        this.mItemClickListener = listener;
    }

    public void addActionItem(final ActionItem action) {
        this.actionItems.add(action);
        String title = action.getTitle();
        TextView container = (TextView)this.mInflater.inflate(R.layout.action_item, (ViewGroup)this.mTrack, false);
        container.setTextColor(this.mTextColor);
        if (title != null) {
            container.setText((CharSequence)String.format(" %s ", title));
        }
        if (action.haveIcon()) {
            int iconSize = this.mResource.getDimensionPixelOffset(R.dimen.icon_size);
            Drawable icon = action.getIconDrawable(this.getContext());
            icon.setBounds(0, 0, iconSize, iconSize);
            if (this.mOrientation == 0) {
                container.setCompoundDrawablesRelative(null, icon, null, null);
            } else {
                container.setCompoundDrawablesRelative(icon, null, null, null);
            }
        }
        final int pos = this.mChildPos;
        container.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QuickAction.this.mItemClickListener != null) {
                    QuickAction.this.mItemClickListener.onItemClick(action);
                }
                if (!QuickAction.this.getActionItem(pos).isSticky()) {
                    QuickAction.this.mDidAction = true;
                    QuickAction.this.dismiss();
                }
            }
        });
        container.setFocusable(true);
        container.setClickable(true);
        if (this.mOrientation == 0 && this.mChildPos != 0) {
            View separator = new View(this.getContext());
            separator.setBackgroundColor(Color.argb((int)32, (int)0, (int)0, (int)0));
            int width = this.mResource.getDimensionPixelOffset(R.dimen.separator_width);
            this.mTrack.addView(separator, this.mInsertPos++, new ViewGroup.LayoutParams(width, -1));
        }
        this.mTrack.addView((View)container, this.mInsertPos);
        ++this.mChildPos;
        ++this.mInsertPos;
    }

    public ActionItem getActionItem(int index) {
        return this.actionItems.get(index);
    }

    private void show(@NonNull Activity activity, @IdRes int anchorId) {
        this.show(activity.findViewById(anchorId));
    }

    public void show(View anchor) {
        int yPos;
        boolean onTop;
        int arrowPos;
        int xPos;
        if (this.getContext() == null) {
            throw new IllegalStateException("Why context is null? It shouldn't be.");
        }
        this.preShow();
        this.mDidAction = false;
        int[] location = new int[2];
        anchor.getLocationOnScreen(location);
        Rect anchorRect = new Rect(location[0], location[1], location[0] + anchor.getWidth(), location[1] + anchor.getHeight());
        this.mRootView.measure(-2, -2);
        int rootHeight = this.mRootView.getMeasuredHeight();
        if (this.rootWidth == 0) {
            this.rootWidth = this.mRootView.getMeasuredWidth();
        }
        DisplayMetrics displaymetrics = new DisplayMetrics();
        this.mWindowManager.getDefaultDisplay().getMetrics(displaymetrics);
        int screenWidth = displaymetrics.widthPixels;
        int screenHeight = displaymetrics.heightPixels;
        if (anchorRect.left + this.rootWidth > screenWidth) {
            xPos = anchorRect.left - (this.rootWidth - anchor.getWidth());
            xPos = xPos < 0 ? 0 : xPos;
            arrowPos = anchorRect.centerX() - xPos;
        } else {
            xPos = anchor.getWidth() > this.rootWidth ? anchorRect.centerX() - this.rootWidth / 2 : anchorRect.left;
            arrowPos = anchorRect.centerX() - xPos;
        }
        int dyTop = anchorRect.top;
        int dyBottom = screenHeight - anchorRect.bottom;
        boolean bl = onTop = dyTop > dyBottom;
        if (onTop) {
            if (rootHeight > dyTop) {
                yPos = 15;
                ViewGroup.LayoutParams l = this.mScroller.getLayoutParams();
                l.height = dyTop - anchor.getHeight();
            } else {
                yPos = anchorRect.top - rootHeight;
            }
        } else {
            yPos = anchorRect.bottom;
            if (rootHeight > dyBottom) {
                ViewGroup.LayoutParams l = this.mScroller.getLayoutParams();
                l.height = dyBottom;
            }
        }
        this.showArrow(onTop ? R.id.arrow_down : R.id.arrow_up, arrowPos);
        this.setAnimationStyle(screenWidth, anchorRect.centerX(), onTop);
        this.mWindow.showAtLocation(anchor, 0, xPos, yPos);
    }

    private void setAnimationStyle(int screenWidth, int requestedX, boolean onTop) {
        int arrowPos = requestedX - this.mArrowUp.getMeasuredWidth() / 2;
        switch (this.mAnimStyle) {
            case AUTO: {
                if (arrowPos <= screenWidth / 4) {
                    this.mWindow.setAnimationStyle(Animation.GROW_FROM_LEFT.get(onTop));
                    break;
                }
                if (arrowPos > screenWidth / 4 && arrowPos < 3 * (screenWidth / 4)) {
                    this.mWindow.setAnimationStyle(Animation.GROW_FROM_CENTER.get(onTop));
                    break;
                }
                this.mWindow.setAnimationStyle(Animation.GROW_FROM_RIGHT.get(onTop));
                break;
            }
            default: {
                this.mWindow.setAnimationStyle(this.mAnimStyle.get(onTop));
            }
        }
    }

    private void showArrow(int whichArrow, int requestedX) {
        View showArrow = whichArrow == R.id.arrow_up ? this.mArrowUp : this.mArrowDown;
        View hideArrow = whichArrow == R.id.arrow_up ? this.mArrowDown : this.mArrowUp;
        int arrowWidth = this.mArrowUp.getMeasuredWidth();
        showArrow.setVisibility(0);
        ViewGroup.MarginLayoutParams param = (ViewGroup.MarginLayoutParams)showArrow.getLayoutParams();
        param.leftMargin = requestedX - arrowWidth / 2;
        hideArrow.setVisibility(8);
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.setOnDismissListener(this);
        this.mDismissListener = listener;
    }

    public void onDismiss() {
        if (!this.mDidAction && this.mDismissListener != null) {
            this.mDismissListener.onDismiss();
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    public static interface OnActionItemClickListener {
        public void onItemClick(ActionItem var1);
    }

    public static enum Animation {
        GROW_FROM_LEFT{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Left : R.style.Animation_PopDownMenu_Left;
            }
        }
        ,
        GROW_FROM_RIGHT{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Right : R.style.Animation_PopDownMenu_Right;
            }
        }
        ,
        GROW_FROM_CENTER{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Center : R.style.Animation_PopDownMenu_Center;
            }
        }
        ,
        REFLECT{

            @Override
            int get(boolean onTop) {
                return onTop ? R.style.Animation_PopUpMenu_Reflect : R.style.Animation_PopDownMenu_Reflect;
            }
        }
        ,
        AUTO{

            @Override
            int get(boolean onTop) {
                throw new UnsupportedOperationException("Can't use this");
            }
        };


        @StyleRes
        abstract int get(boolean var1);
    }
}

