/*
 * Decompiled with CFR 0.152.
 */
package me.piruin.quickaction;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.widget.PopupWindow;

class PopupWindows {
    PopupWindow mWindow;
    private View mRootView;
    private Context mContext;

    PopupWindows(Context context) {
        this.mContext = context;
        this.mWindow = new PopupWindow(context);
        this.mWindow.setTouchInterceptor(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                if (event.getAction() == 4) {
                    PopupWindows.this.mWindow.dismiss();
                    return true;
                }
                if (event.getAction() == 11) {
                    view.performClick();
                    return true;
                }
                return false;
            }
        });
    }

    Context getContext() {
        return this.mContext;
    }

    void preShow() {
        if (this.mRootView == null) {
            throw new IllegalStateException("setContentView was not called with a view to display.");
        }
        this.mWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mWindow.setWidth(-2);
        this.mWindow.setHeight(-2);
        this.mWindow.setTouchable(true);
        this.mWindow.setFocusable(true);
        this.mWindow.setOutsideTouchable(true);
        this.mWindow.setContentView(this.mRootView);
        this.setShadows();
    }

    @TargetApi(value=21)
    private void setShadows() {
        if (Build.VERSION.SDK_INT >= 21) {
            this.mWindow.setElevation(10.0f);
        }
    }

    void setContentView(View root) {
        this.mRootView = root;
        this.mWindow.setContentView(root);
    }

    void setOnDismissListener(PopupWindow.OnDismissListener listener) {
        this.mWindow.setOnDismissListener(listener);
    }

    void dismiss() {
        this.mWindow.dismiss();
    }
}

