/*
 * Decompiled with CFR 0.152.
 */
package me.paulschwarz.springdotenv;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;

class DotenvConfigProperties {
    private static final Log log = LogFactory.getLog(DotenvConfigProperties.class);
    private static final String PROPERTIES_FILE = ".env.properties";

    private DotenvConfigProperties() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Properties loadProperties() {
        Properties properties = new Properties();
        try (InputStream input = DotenvConfigProperties.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
            if (Objects.isNull(input)) {
                log.debug((Object)LogMessage.format((String)"Property file not found \"%s\", falling back to defaults", (Object)PROPERTIES_FILE));
                Properties properties2 = new Properties();
                return properties2;
            }
            properties.load(input);
            return properties;
        }
        catch (IOException e) {
            log.warn((Object)LogMessage.format((String)"Error loading property file \"%s\", falling back to defaults. Caused by: %s", (Object)PROPERTIES_FILE, (Object)e.getMessage()));
        }
        return properties;
    }
}

