/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.PagerFixedItem;

public class PagerFixedItemManager {
    @Nullable
    private ArrayList<PagerFixedItem> itemList;
    @Nullable
    private ArrayList<PagerFixedItem> enabledItemList;

    public void add(@NonNull PagerFixedItem fixedItem) {
        ArrayList<PagerFixedItem<Object>> allList = this.itemList;
        if (allList == null) {
            allList = new ArrayList();
            this.itemList = allList;
        }
        fixedItem.setPositionInPartItemList(allList.size());
        allList.add(fixedItem);
        this.refreshEnabledList();
    }

    private void refreshEnabledList() {
        ArrayList<PagerFixedItem> allList = this.itemList;
        if (allList != null) {
            ArrayList<PagerFixedItem<Object>> enabledList = this.enabledItemList;
            if (enabledList == null) {
                enabledList = new ArrayList();
                this.enabledItemList = enabledList;
            } else {
                enabledList.clear();
            }
            for (PagerFixedItem fixedItem : allList) {
                if (!fixedItem.isEnabled()) continue;
                fixedItem.setPositionInPartList(enabledList.size());
                enabledList.add(fixedItem);
            }
        }
    }

    boolean itemEnabledChanged() {
        this.refreshEnabledList();
        return true;
    }

    public int getItemCount() {
        return this.itemList != null ? this.itemList.size() : 0;
    }

    @NonNull
    public PagerFixedItem getItem(int index) {
        if (this.itemList != null) {
            return this.itemList.get(index);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    @NonNull
    <DATA> PagerFixedItem<DATA> getItemByFactoryClass(@NonNull Class<? extends AssemblyPagerItemFactory<DATA>> clazz, int number) {
        if (this.itemList != null) {
            int currentNumber = 0;
            for (PagerFixedItem item : this.itemList) {
                if (!clazz.equals(item.getItemFactory().getClass())) continue;
                if (currentNumber == number) {
                    return item;
                }
                ++currentNumber;
            }
        }
        throw new IllegalArgumentException("Not found Item by class=" + clazz.toString() + " and number=" + number);
    }

    @NonNull
    <DATA> PagerFixedItem<DATA> getItemByFactoryClass(@NonNull Class<? extends AssemblyPagerItemFactory<DATA>> clazz) {
        return this.getItemByFactoryClass(clazz, 0);
    }

    void setItemData(int index, @Nullable Object data) {
        this.getItem(index).setData(data);
    }

    boolean isItemEnabled(int index) {
        return this.getItem(index).isEnabled();
    }

    void setItemEnabled(int index, boolean enabled) {
        this.getItem(index).setEnabled(enabled);
    }

    int getEnabledItemCount() {
        return this.enabledItemList != null ? this.enabledItemList.size() : 0;
    }

    @NonNull
    PagerFixedItem getItemInEnabledList(int index) {
        if (this.enabledItemList != null) {
            return this.enabledItemList.get(index);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }
}

