/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.panpf.adapter.pager.AssemblyFragmentItemFactory;
import me.panpf.adapter.pager.FragmentFixedItem;
import me.panpf.adapter.pager.FragmentFixedItemManager;

class FragmentItemManager {
    @NonNull
    private PagerAdapter adapter;
    @NonNull
    private FragmentFixedItemManager headerItemManager = new FragmentFixedItemManager();
    @NonNull
    private ArrayList<AssemblyFragmentItemFactory> itemFactoryList = new ArrayList();
    @NonNull
    private FragmentFixedItemManager footerItemManager = new FragmentFixedItemManager();
    @Nullable
    private List dataList;

    FragmentItemManager(@NonNull PagerAdapter adapter) {
        this.adapter = adapter;
    }

    FragmentItemManager(@NonNull PagerAdapter adapter, @Nullable List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    FragmentItemManager(@NonNull PagerAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    public void addItemFactory(@NonNull AssemblyFragmentItemFactory itemFactory) {
        if (itemFactory == null) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        this.itemFactoryList.add(itemFactory);
        itemFactory.attachToAdapter(this.adapter);
    }

    @NonNull
    public ArrayList<AssemblyFragmentItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> addHeaderItem(@NonNull FragmentFixedItem<DATA> fixedItem) {
        if (fixedItem.isAttached()) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        this.headerItemManager.add(fixedItem);
        fixedItem.getItemFactory().attachToAdapter(this.adapter);
        fixedItem.attachToAdapter(this, true);
        return fixedItem;
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> addHeaderItem(@NonNull AssemblyFragmentItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.addHeaderItem(new FragmentFixedItem<DATA>(itemFactory, data));
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> addHeaderItem(@NonNull AssemblyFragmentItemFactory<DATA> itemFactory) {
        return this.addHeaderItem(new FragmentFixedItem<Object>(itemFactory, null));
    }

    @NonNull
    FragmentFixedItemManager getHeaderItemManager() {
        return this.headerItemManager;
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> addFooterItem(@NonNull FragmentFixedItem<DATA> fixedItem) {
        if (fixedItem.isAttached()) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        this.footerItemManager.add(fixedItem);
        fixedItem.getItemFactory().attachToAdapter(this.adapter);
        fixedItem.attachToAdapter(this, false);
        return fixedItem;
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> addFooterItem(@NonNull AssemblyFragmentItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.addFooterItem(new FragmentFixedItem<DATA>(itemFactory, data));
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> addFooterItem(@NonNull AssemblyFragmentItemFactory<DATA> itemFactory) {
        return this.addFooterItem(new FragmentFixedItem<Object>(itemFactory, null));
    }

    @NonNull
    FragmentFixedItemManager getFooterItemManager() {
        return this.footerItemManager;
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(@Nullable List dataList) {
        FragmentItemManager fragmentItemManager = this;
        synchronized (fragmentItemManager) {
            this.dataList = dataList;
        }
        this.adapter.notifyDataSetChanged();
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    public int getItemCount() {
        return this.headerItemManager.getItemCount() + this.getDataCount() + this.footerItemManager.getItemCount();
    }

    @NonNull
    public AssemblyFragmentItemFactory getItemFactoryByPosition(int position) {
        int headerItemCount = this.headerItemManager.getItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemManager.getItem(positionInHeaderList).getItemFactory();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getData(positionInDataList);
            int size = this.itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyFragmentItemFactory itemFactory = this.itemFactoryList.get(w);
                if (!itemFactory.match(dataObject)) continue;
                return itemFactory;
            }
            throw new IllegalStateException(String.format("Didn't find suitable AssemblyPagerItemFactory. position=%d, dataObject=%s", position, dataObject != null ? dataObject.getClass().getName() : null));
        }
        int footerItemCount = this.footerItemManager.getItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemManager.getItem(positionInFooterList).getItemFactory();
        }
        throw new IllegalStateException("Not found PagerItemFactory by position: " + position);
    }

    @Nullable
    public Object getItemDataByPosition(int position) {
        int headerItemCount = this.headerItemManager.getItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemManager.getItem(positionInHeaderList).getData();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            return this.getData(positionInDataList);
        }
        int footerItemCount = this.footerItemManager.getItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemManager.getItem(positionInFooterList).getData();
        }
        throw new IllegalArgumentException("Not found item data by position: " + position);
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.headerItemManager.getItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.footerItemManager.getItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    public boolean isHeaderItem(int position) {
        int headerItemCount = this.headerItemManager.getItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        return position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0;
    }

    public boolean isBodyItem(int position) {
        int headerItemCount = this.headerItemManager.getItemCount();
        int headerEndPosition = headerItemCount - 1;
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        return position >= dataStartPosition && position <= dataEndPosition && dataCount > 0;
    }

    public boolean isFooterItem(int position) {
        int headerItemCount = this.headerItemManager.getItemCount();
        int headerEndPosition = headerItemCount - 1;
        int dataCount = this.getDataCount();
        int dataEndPosition = headerEndPosition + dataCount;
        int footerItemCount = this.footerItemManager.getItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        return position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0;
    }
}

