/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.panpf.adapter.OnClickListener;
import me.panpf.adapter.OnLongClickListener;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.PagerClickListenerManager;

public abstract class AssemblyPagerItemFactory<DATA> {
    @Nullable
    private AssemblyPagerAdapter adapter;
    @Nullable
    private PagerClickListenerManager<DATA> clickListenerManager;

    @Nullable
    public AssemblyPagerAdapter getAdapter() {
        return this.adapter;
    }

    void attachToAdapter(@Nullable AssemblyPagerAdapter adapter) {
        this.adapter = adapter;
    }

    public AssemblyPagerItemFactory<DATA> setOnViewClickListener(@IdRes int viewId, @NonNull OnClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new PagerClickListenerManager();
        }
        this.clickListenerManager.add(viewId, onClickListener);
        return this;
    }

    public AssemblyPagerItemFactory<DATA> setOnItemClickListener(@NonNull OnClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new PagerClickListenerManager();
        }
        this.clickListenerManager.add(onClickListener);
        return this;
    }

    public AssemblyPagerItemFactory<DATA> setOnViewLongClickListener(@IdRes int viewId, @NonNull OnLongClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new PagerClickListenerManager();
        }
        this.clickListenerManager.add(viewId, onClickListener);
        return this;
    }

    public AssemblyPagerItemFactory<DATA> setOnItemLongClickListener(@NonNull OnLongClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new PagerClickListenerManager();
        }
        this.clickListenerManager.add(onClickListener);
        return this;
    }

    protected View dispatchCreateView(@NonNull Context context, @NonNull ViewGroup container, int position, @Nullable DATA data) {
        View itemView = this.createView(context, container, position, data);
        if (this.clickListenerManager != null) {
            this.clickListenerManager.register(this, itemView, position, data);
        }
        return itemView;
    }

    public abstract boolean match(@Nullable Object var1);

    public abstract View createView(@NonNull Context var1, @NonNull ViewGroup var2, int var3, @Nullable DATA var4);
}

