/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.viewpager.widget.PagerAdapter;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.PagerFixedItem;
import me.panpf.adapter.pager.PagerItemManager;

public class AssemblyPagerAdapter
extends PagerAdapter {
    @NonNull
    private PagerItemManager itemManager;
    private int notifyNumber = 0;
    @Nullable
    private SparseIntArray notifyNumberPool;

    public AssemblyPagerAdapter() {
        this.itemManager = new PagerItemManager(this);
    }

    public AssemblyPagerAdapter(@Nullable List dataList) {
        this.itemManager = new PagerItemManager(this, dataList);
    }

    public AssemblyPagerAdapter(@Nullable Object[] dataArray) {
        this.itemManager = new PagerItemManager(this, dataArray);
    }

    public void addItemFactory(@NonNull AssemblyPagerItemFactory itemFactory) {
        this.itemManager.addItemFactory(itemFactory);
    }

    @NonNull
    public List<AssemblyPagerItemFactory> getItemFactoryList() {
        return this.itemManager.getItemFactoryList();
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addHeaderItem(@NonNull PagerFixedItem<DATA> fixedItem) {
        return this.itemManager.addHeaderItem(fixedItem);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addHeaderItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.itemManager.addHeaderItem(itemFactory, data);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addHeaderItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory) {
        return this.itemManager.addHeaderItem(itemFactory);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> getHeaderItemByFactoryClass(@NonNull Class<? extends AssemblyPagerItemFactory<DATA>> clazz, int number) {
        return this.itemManager.getHeaderItemManager().getItemByFactoryClass(clazz, number);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> getHeaderItemByFactoryClass(@NonNull Class<? extends AssemblyPagerItemFactory<DATA>> clazz) {
        return this.itemManager.getHeaderItemManager().getItemByFactoryClass(clazz);
    }

    @NonNull
    public PagerFixedItem getHeaderItem(int positionInHeaderItemList) {
        return this.itemManager.getHeaderItemManager().getItem(positionInHeaderItemList);
    }

    @Nullable
    public Object getHeaderItemData(int positionInHeaderItemList) {
        return this.itemManager.getHeaderItemManager().getItem(positionInHeaderItemList).getData();
    }

    public void setHeaderItemData(int positionInHeaderItemList, @Nullable Object data) {
        this.itemManager.getHeaderItemManager().setItemData(positionInHeaderItemList, data);
    }

    public boolean isHeaderItemEnabled(int positionInHeaderItemList) {
        return this.itemManager.getHeaderItemManager().isItemEnabled(positionInHeaderItemList);
    }

    public void setHeaderItemEnabled(int positionInHeaderItemList, boolean enabled) {
        this.itemManager.getHeaderItemManager().setItemEnabled(positionInHeaderItemList, enabled);
    }

    public int getHeaderCount() {
        return this.itemManager.getHeaderItemManager().getEnabledItemCount();
    }

    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.itemManager.getHeaderItemManager().getItemInEnabledList(positionInHeaderList).getData();
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addFooterItem(@NonNull PagerFixedItem<DATA> fixedItem) {
        return this.itemManager.addFooterItem(fixedItem);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addFooterItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.itemManager.addFooterItem(itemFactory, data);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addFooterItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory) {
        return this.itemManager.addFooterItem(itemFactory);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> getFooterItemByFactoryClass(@NonNull Class<? extends AssemblyPagerItemFactory<DATA>> clazz, int number) {
        return this.itemManager.getFooterItemManager().getItemByFactoryClass(clazz, number);
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> getFooterItemByFactoryClass(@NonNull Class<? extends AssemblyPagerItemFactory<DATA>> clazz) {
        return this.itemManager.getFooterItemManager().getItemByFactoryClass(clazz);
    }

    @NonNull
    public PagerFixedItem getFooterItem(int positionInFooterItemList) {
        return this.itemManager.getFooterItemManager().getItem(positionInFooterItemList);
    }

    @Nullable
    public Object getFooterItemData(int positionInFooterItemList) {
        return this.itemManager.getFooterItemManager().getItem(positionInFooterItemList).getData();
    }

    public void setFooterItemData(int positionInFooterItemList, @Nullable Object data) {
        this.itemManager.getFooterItemManager().setItemData(positionInFooterItemList, data);
    }

    public boolean isFooterItemEnabled(int positionInFooterItemList) {
        return this.itemManager.getFooterItemManager().isItemEnabled(positionInFooterItemList);
    }

    public void setFooterItemEnabled(int positionInFooterItemList, boolean enabled) {
        this.itemManager.getFooterItemManager().setItemEnabled(positionInFooterItemList, enabled);
    }

    public int getFooterCount() {
        return this.itemManager.getFooterItemManager().getEnabledItemCount();
    }

    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.itemManager.getFooterItemManager().getItemInEnabledList(positionInFooterList).getData();
    }

    @Nullable
    public List getDataList() {
        return this.itemManager.getDataList();
    }

    public void setDataList(@Nullable List dataList) {
        this.itemManager.setDataList(dataList);
    }

    public void addAll(@Nullable Collection collection) {
        this.itemManager.addAll(collection);
    }

    public void addAll(Object ... items) {
        this.itemManager.addAll(items);
    }

    public void insert(@NonNull Object object, int index) {
        this.itemManager.insert(object, index);
    }

    public void remove(@NonNull Object object) {
        this.itemManager.remove(object);
    }

    public void clear() {
        this.itemManager.clear();
    }

    public void sort(@NonNull Comparator comparator) {
        this.itemManager.sort(comparator);
    }

    public int getDataCount() {
        return this.itemManager.getDataCount();
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.itemManager.getData(positionInDataList);
    }

    public boolean isHeaderItem(int position) {
        return this.itemManager.isHeaderItem(position);
    }

    public boolean isBodyItem(int position) {
        return this.itemManager.isBodyItem(position);
    }

    public boolean isFooterItem(int position) {
        return this.itemManager.isFooterItem(position);
    }

    public int getPositionInPart(int position) {
        return this.itemManager.getPositionInPart(position);
    }

    @NonNull
    public AssemblyPagerItemFactory getItemFactoryByPosition(int position) {
        return this.itemManager.getItemFactoryByPosition(position);
    }

    public int getCount() {
        return this.itemManager.getItemCount();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        AssemblyPagerItemFactory itemFactory = this.itemManager.getItemFactoryByPosition(position);
        Object itemData = this.itemManager.getItemDataByPosition(position);
        View itemView = itemFactory.dispatchCreateView(container.getContext(), container, position, itemData);
        container.addView(itemView);
        return itemView;
    }

    public boolean isNotifyOnChange() {
        return this.itemManager.isNotifyOnChange();
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.itemManager.setNotifyOnChange(notifyOnChange);
    }

    public boolean isEnabledPositionNoneOnNotifyDataSetChanged() {
        return this.notifyNumberPool != null;
    }

    public void setEnabledPositionNoneOnNotifyDataSetChanged(boolean enabled) {
        if (enabled) {
            this.notifyNumberPool = new SparseIntArray();
            this.notifyNumber = 0;
        } else {
            this.notifyNumberPool = null;
        }
    }

    public void notifyDataSetChanged() {
        if (this.notifyNumberPool != null) {
            ++this.notifyNumber;
        }
        super.notifyDataSetChanged();
    }

    public int getItemPosition(@NonNull Object object) {
        if (this.notifyNumberPool != null && this.notifyNumberPool.get(object.hashCode()) != this.notifyNumber) {
            this.notifyNumberPool.put(object.hashCode(), this.notifyNumber);
            return -2;
        }
        return super.getItemPosition(object);
    }
}

