/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.expandable;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemManager;
import me.panpf.adapter.ViewTypeManager;
import me.panpf.adapter.expandable.AssemblyGroup;

public class ExpandableItemManager
extends ItemManager {
    @NonNull
    private ViewTypeManager<ItemFactory> childViewTypeManager = new ViewTypeManager();
    @NonNull
    private ArrayList<ItemFactory> childItemFactoryList = new ArrayList();

    public ExpandableItemManager(@NonNull AssemblyAdapter adapter) {
        super(adapter);
    }

    public ExpandableItemManager(@NonNull AssemblyAdapter adapter, @Nullable List dataList) {
        super(adapter, dataList);
    }

    public ExpandableItemManager(@NonNull AssemblyAdapter adapter, @Nullable Object[] dataArray) {
        super(adapter, dataArray);
    }

    public void addChildItemFactory(@NonNull ItemFactory childItemFactory) {
        if (childItemFactory == null || this.childViewTypeManager.isLocked()) {
            throw new IllegalStateException("childItemFactory is null or item factory list locked");
        }
        this.childItemFactoryList.add(childItemFactory);
        int viewType = this.childViewTypeManager.add(childItemFactory);
        childItemFactory.attachToAdapter(this.getAdapter(), viewType);
    }

    @NonNull
    public ArrayList<ItemFactory> getChildItemFactoryList() {
        return this.childItemFactoryList;
    }

    public int getChildTypeCount() {
        if (!this.childViewTypeManager.isLocked()) {
            this.childViewTypeManager.lock();
        }
        return this.childViewTypeManager.getCount();
    }

    @NonNull
    public ItemFactory getChildItemFactoryByViewType(int viewType) {
        ItemFactory itemFactory = this.childViewTypeManager.get(viewType);
        if (itemFactory != null) {
            return itemFactory;
        }
        throw new IllegalArgumentException("Unknown child viewType. viewType=" + viewType);
    }

    public int getChildrenCount(int groupPosition) {
        Object groupObject = this.getItemDataByPosition(groupPosition);
        if (groupObject instanceof AssemblyGroup) {
            return ((AssemblyGroup)groupObject).getChildCount();
        }
        return 0;
    }

    @Nullable
    public Object getChildDataByPosition(int groupPosition, int childPosition) {
        Object groupDataObject = this.getItemDataByPosition(groupPosition);
        if (groupDataObject == null) {
            throw new IllegalArgumentException("Not found group item data by group position: " + groupPosition);
        }
        if (!(groupDataObject instanceof AssemblyGroup)) {
            throw new IllegalArgumentException(String.format("group object must implements AssemblyGroup interface. groupPosition=%d, groupDataObject=%s", groupPosition, groupDataObject.getClass().getName()));
        }
        return ((AssemblyGroup)groupDataObject).getChild(childPosition);
    }

    public int getChildViewType(int groupPosition, int childPosition) {
        if (this.childItemFactoryList.size() <= 0) {
            throw new IllegalStateException("You need to configure ItemFactory use addChildItemFactory method");
        }
        Object childDataObject = this.getChildDataByPosition(groupPosition, childPosition);
        int size = this.childItemFactoryList.size();
        for (int w = 0; w < size; ++w) {
            ItemFactory childItemFactory = this.childItemFactoryList.get(w);
            if (!childItemFactory.match(childDataObject)) continue;
            return childItemFactory.getViewType();
        }
        throw new IllegalStateException(String.format("Didn't find suitable ItemFactory. groupPosition=%d, childPosition=%d, childDataObject=%s", groupPosition, childPosition, childDataObject != null ? childDataObject.getClass().getName() : "null"));
    }
}

