/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import me.panpf.adapter.pager.AssemblyFragmentItemFactory;
import me.panpf.adapter.pager.FragmentFixedItem;

public class FragmentFixedItemManager {
    @Nullable
    private ArrayList<FragmentFixedItem> itemList;

    public void add(@NonNull FragmentFixedItem fixedItem) {
        ArrayList<FragmentFixedItem<Object>> allList = this.itemList;
        if (allList == null) {
            allList = new ArrayList();
            this.itemList = allList;
        }
        fixedItem.setPositionInPartItemList(allList.size());
        allList.add(fixedItem);
    }

    public int getItemCount() {
        return this.itemList != null ? this.itemList.size() : 0;
    }

    @NonNull
    public FragmentFixedItem getItem(int index) {
        if (this.itemList != null) {
            return this.itemList.get(index);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> getItemByFactoryClass(@NonNull Class<? extends AssemblyFragmentItemFactory<DATA>> clazz, int number) {
        if (this.itemList != null) {
            int currentNumber = 0;
            for (FragmentFixedItem item : this.itemList) {
                if (!clazz.equals(item.getItemFactory().getClass())) continue;
                if (currentNumber == number) {
                    return item;
                }
                ++currentNumber;
            }
        }
        throw new IllegalArgumentException("Not found Item by class=" + clazz.toString() + " and number=" + number);
    }

    @NonNull
    public <DATA> FragmentFixedItem<DATA> getItemByFactoryClass(@NonNull Class<? extends AssemblyFragmentItemFactory<DATA>> clazz) {
        return this.getItemByFactoryClass(clazz, 0);
    }

    public void setItemData(int index, @Nullable Object data) {
        this.getItem(index).setData(data);
    }
}

