/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.recycler;

import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import me.panpf.adapter.AssemblyRecyclerAdapter;

public class AssemblyRecyclerLinerDivider
extends RecyclerView.ItemDecoration {
    private static final int[] ATTRS = new int[]{16843284};
    private Drawable mDivider;
    private RecyclerView recyclerView;

    public AssemblyRecyclerLinerDivider(RecyclerView recyclerView) {
        this.recyclerView = recyclerView;
        TypedArray a = recyclerView.getContext().obtainStyledAttributes(ATTRS);
        this.mDivider = a.getDrawable(0);
        a.recycle();
    }

    public AssemblyRecyclerLinerDivider(RecyclerView recyclerView, Drawable dividerDrawable) {
        this.recyclerView = recyclerView;
        this.mDivider = dividerDrawable;
    }

    public AssemblyRecyclerLinerDivider(RecyclerView recyclerView, @DrawableRes int dividerDrawableResId) {
        this(recyclerView, recyclerView.getResources().getDrawable(dividerDrawableResId));
    }

    public void getItemOffsets(@NonNull Rect outRect, @NonNull View view, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = this.recyclerView.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            outRect.set(0, 0, 0, 0);
            return;
        }
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
        int mOrientation = linearLayoutManager.getOrientation();
        int itemPosition = 0;
        int firstDataItemPosition = 0;
        int lastDataItemPosition = 0;
        RecyclerView.Adapter adapter = this.recyclerView.getAdapter();
        AssemblyRecyclerAdapter recyclerAdapter = null;
        if (adapter instanceof AssemblyRecyclerAdapter) {
            recyclerAdapter = (AssemblyRecyclerAdapter)adapter;
            itemPosition = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewLayoutPosition();
            firstDataItemPosition = recyclerAdapter.getHeaderCount();
            lastDataItemPosition = firstDataItemPosition + (recyclerAdapter.getDataCount() - 1);
        }
        if (recyclerAdapter == null || itemPosition >= firstDataItemPosition && itemPosition <= lastDataItemPosition) {
            if (mOrientation == 1) {
                outRect.set(0, 0, 0, this.mDivider.getIntrinsicHeight());
            } else {
                outRect.set(0, 0, this.mDivider.getIntrinsicWidth(), 0);
            }
        } else {
            outRect.set(0, 0, 0, 0);
        }
    }

    public void onDraw(@NonNull Canvas c, @NonNull RecyclerView parent, @NonNull RecyclerView.State state) {
        RecyclerView.LayoutManager layoutManager = this.recyclerView.getLayoutManager();
        if (!(layoutManager instanceof LinearLayoutManager)) {
            return;
        }
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
        int mOrientation = linearLayoutManager.getOrientation();
        if (mOrientation == 1) {
            this.drawVertical(c, parent);
        } else {
            this.drawHorizontal(c, parent);
        }
    }

    private void drawVertical(Canvas c, RecyclerView parent) {
        int firstDataItemPosition = 0;
        int lastDataItemPosition = 0;
        RecyclerView.Adapter adapter = this.recyclerView.getAdapter();
        AssemblyRecyclerAdapter recyclerAdapter = null;
        if (adapter instanceof AssemblyRecyclerAdapter) {
            recyclerAdapter = (AssemblyRecyclerAdapter)adapter;
            firstDataItemPosition = recyclerAdapter.getHeaderCount();
            lastDataItemPosition = firstDataItemPosition + (recyclerAdapter.getDataCount() - 1);
        }
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int itemPosition = ((RecyclerView.LayoutParams)child.getLayoutParams()).getViewLayoutPosition();
            int bottomMargin = ((RecyclerView.LayoutParams)child.getLayoutParams()).bottomMargin;
            if (recyclerAdapter != null && (itemPosition < firstDataItemPosition || itemPosition > lastDataItemPosition)) continue;
            int top = child.getBottom() + bottomMargin;
            int bottom = top + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }

    private void drawHorizontal(Canvas c, RecyclerView parent) {
        int firstDataItemPosition = 0;
        int lastDataItemPosition = 0;
        RecyclerView.Adapter adapter = this.recyclerView.getAdapter();
        AssemblyRecyclerAdapter recyclerAdapter = null;
        if (adapter instanceof AssemblyRecyclerAdapter) {
            recyclerAdapter = (AssemblyRecyclerAdapter)adapter;
            firstDataItemPosition = recyclerAdapter.getHeaderCount();
            lastDataItemPosition = firstDataItemPosition + (recyclerAdapter.getDataCount() - 1);
        }
        int top = parent.getPaddingTop();
        int bottom = parent.getHeight() - parent.getPaddingBottom();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            int itemPosition = ((RecyclerView.LayoutParams)child.getLayoutParams()).getViewLayoutPosition();
            int rightMargin = ((RecyclerView.LayoutParams)child.getLayoutParams()).rightMargin;
            if (recyclerAdapter != null && (itemPosition < firstDataItemPosition || itemPosition > lastDataItemPosition)) continue;
            int left = child.getRight() + rightMargin;
            int right = left + this.mDivider.getIntrinsicHeight();
            this.mDivider.setBounds(left, top, right, bottom);
            this.mDivider.draw(c);
        }
    }
}

