/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.PagerFixedItem;
import me.panpf.adapter.pager.PagerFixedItemManager;

public class PagerItemManager {
    @NonNull
    private AssemblyPagerAdapter adapter;
    @NonNull
    private PagerFixedItemManager headerItemManager = new PagerFixedItemManager();
    @NonNull
    private ArrayList<AssemblyPagerItemFactory> itemFactoryList = new ArrayList();
    @NonNull
    private PagerFixedItemManager footerItemManager = new PagerFixedItemManager();
    @Nullable
    private List dataList;
    private boolean notifyOnChange = true;

    PagerItemManager(@NonNull AssemblyPagerAdapter adapter) {
        this.adapter = adapter;
    }

    PagerItemManager(@NonNull AssemblyPagerAdapter adapter, @Nullable List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    PagerItemManager(@NonNull AssemblyPagerAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    public void addItemFactory(@NonNull AssemblyPagerItemFactory itemFactory) {
        if (itemFactory == null) {
            throw new IllegalArgumentException("itemFactory is null");
        }
        this.itemFactoryList.add(itemFactory);
        itemFactory.attachToAdapter(this.adapter);
    }

    @NonNull
    public ArrayList<AssemblyPagerItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addHeaderItem(@NonNull PagerFixedItem<DATA> fixedItem) {
        if (fixedItem.isAttached()) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        this.headerItemManager.add(fixedItem);
        fixedItem.getItemFactory().attachToAdapter(this.adapter);
        fixedItem.attachToAdapter(this, true);
        return fixedItem;
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addHeaderItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.addHeaderItem(new PagerFixedItem<DATA>(itemFactory, data));
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addHeaderItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory) {
        return this.addHeaderItem(new PagerFixedItem<Object>(itemFactory, null));
    }

    @NonNull
    PagerFixedItemManager getHeaderItemManager() {
        return this.headerItemManager;
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addFooterItem(@NonNull PagerFixedItem<DATA> fixedItem) {
        if (fixedItem.isAttached()) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        this.footerItemManager.add(fixedItem);
        fixedItem.getItemFactory().attachToAdapter(this.adapter);
        fixedItem.attachToAdapter(this, false);
        return fixedItem;
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addFooterItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.addFooterItem(new PagerFixedItem<DATA>(itemFactory, data));
    }

    @NonNull
    public <DATA> PagerFixedItem<DATA> addFooterItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory) {
        return this.addFooterItem(new PagerFixedItem<Object>(itemFactory, null));
    }

    @NonNull
    PagerFixedItemManager getFooterItemManager() {
        return this.footerItemManager;
    }

    void fixedItemEnabledChanged(@NonNull PagerFixedItem fixedItem) {
        if (fixedItem.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (fixedItem.isHeader()) {
            if (this.headerItemManager.itemEnabledChanged() && this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else if (this.footerItemManager.itemEnabledChanged() && this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(@Nullable List dataList) {
        PagerItemManager pagerItemManager = this;
        synchronized (pagerItemManager) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nullable Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        PagerItemManager pagerItemManager = this;
        synchronized (pagerItemManager) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        PagerItemManager pagerItemManager = this;
        synchronized (pagerItemManager) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void insert(@NonNull Object object, int index) {
        if (object == null) {
            return;
        }
        PagerItemManager pagerItemManager = this;
        synchronized (pagerItemManager) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(@NonNull Object object) {
        if (object == null) {
            return;
        }
        PagerItemManager pagerItemManager = this;
        synchronized (pagerItemManager) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        PagerItemManager pagerItemManager = this;
        synchronized (pagerItemManager) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sort(@NonNull Comparator comparator) {
        PagerItemManager pagerItemManager = this;
        synchronized (pagerItemManager) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    public int getItemCount() {
        return this.headerItemManager.getEnabledItemCount() + this.getDataCount() + this.footerItemManager.getEnabledItemCount();
    }

    @NonNull
    public AssemblyPagerItemFactory getItemFactoryByPosition(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemManager.getItemInEnabledList(positionInHeaderList).getItemFactory();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getData(positionInDataList);
            int size = this.itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyPagerItemFactory itemFactory = this.itemFactoryList.get(w);
                if (!itemFactory.match(dataObject)) continue;
                return itemFactory;
            }
            throw new IllegalStateException(String.format("Didn't find suitable AssemblyPagerItemFactory. position=%d, dataObject=%s", position, dataObject != null ? dataObject.getClass().getName() : null));
        }
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemManager.getItemInEnabledList(positionInFooterList).getItemFactory();
        }
        throw new IllegalStateException("Not found PagerItemFactory by position: " + position);
    }

    @Nullable
    public Object getItemDataByPosition(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemManager.getItemInEnabledList(positionInHeaderList).getData();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            return this.getData(positionInDataList);
        }
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemManager.getItemInEnabledList(positionInFooterList).getData();
        }
        throw new IllegalArgumentException("Not found item data by position: " + position);
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    public boolean isHeaderItem(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        return position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0;
    }

    public boolean isBodyItem(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerEndPosition = headerItemCount - 1;
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        return position >= dataStartPosition && position <= dataEndPosition && dataCount > 0;
    }

    public boolean isFooterItem(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerEndPosition = headerItemCount - 1;
        int dataCount = this.getDataCount();
        int dataEndPosition = headerEndPosition + dataCount;
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        return position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0;
    }
}

