/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.PagerItemManager;

public class PagerFixedItem<DATA> {
    @NonNull
    private AssemblyPagerItemFactory<DATA> itemFactory;
    @Nullable
    private DATA data;
    @Nullable
    private PagerItemManager itemManager;
    private boolean header;
    private boolean enabled = true;
    private int positionInPartList;
    private int positionInPartItemList;

    public PagerFixedItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory, @Nullable DATA data) {
        this.itemFactory = itemFactory;
        this.data = data;
    }

    public PagerFixedItem(@NonNull AssemblyPagerItemFactory<DATA> itemFactory) {
        this.itemFactory = itemFactory;
    }

    @Nullable
    public DATA getData() {
        return this.data;
    }

    public void setData(@Nullable DATA data) {
        this.data = data;
        AssemblyPagerAdapter adapter = this.itemFactory.getAdapter();
        if (adapter != null && adapter.isNotifyOnChange()) {
            adapter.notifyDataSetChanged();
        }
    }

    @NonNull
    public AssemblyPagerItemFactory<DATA> getItemFactory() {
        return this.itemFactory;
    }

    public boolean isAttached() {
        return this.itemManager != null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NonNull
    public PagerFixedItem setEnabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            this.enableChanged();
        }
        return this;
    }

    void attachToAdapter(@NonNull PagerItemManager itemManager, boolean header) {
        this.itemManager = itemManager;
        this.header = header;
    }

    private void enableChanged() {
        if (this.itemManager != null) {
            this.itemManager.fixedItemEnabledChanged(this);
        }
    }

    public boolean isHeader() {
        return this.header;
    }

    public int getPositionInPartList() {
        return this.positionInPartList;
    }

    public void setPositionInPartList(int positionInPartList) {
        this.positionInPartList = positionInPartList;
    }

    public int getPositionInPartItemList() {
        return this.positionInPartItemList;
    }

    public void setPositionInPartItemList(int positionInPartItemList) {
        this.positionInPartItemList = positionInPartItemList;
    }
}

