/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.panpf.adapter.AssemblyItem;
import me.panpf.adapter.AssemblyItemFactory;

public class ViewItem
extends AssemblyItem<Object> {
    public ViewItem(@NonNull View itemView) {
        super(itemView);
    }

    @Override
    protected void onSetData(int position, @Nullable Object o) {
    }

    public static interface ViewFactory {
        @NonNull
        public View createItemView(@NonNull ViewGroup var1);
    }

    public static class Factory
    extends AssemblyItemFactory<Object> {
        @NonNull
        private ViewFactory viewFactory;
        @Nullable
        private Class<?> dataClazz;

        public Factory(@NonNull ViewFactory viewFactory, @Nullable Class<?> dataClazz) {
            this.viewFactory = viewFactory;
            this.dataClazz = dataClazz;
        }

        public Factory(@NonNull ViewFactory viewFactory) {
            this(viewFactory, null);
        }

        public Factory(final @LayoutRes int layoutResId, @Nullable Class<?> dataClazz) {
            this(new ViewFactory(){

                @Override
                @NonNull
                public View createItemView(@NonNull ViewGroup parent) {
                    return LayoutInflater.from((Context)parent.getContext()).inflate(layoutResId, parent, false);
                }
            }, dataClazz);
        }

        public Factory(@LayoutRes int layoutResId) {
            this(layoutResId, null);
        }

        public Factory(final @NonNull View view, @Nullable Class<?> dataClazz) {
            this(new ViewFactory(){

                @Override
                @NonNull
                public View createItemView(@NonNull ViewGroup parent) {
                    return view;
                }
            }, dataClazz);
        }

        public Factory(@NonNull View view) {
            this(view, null);
        }

        @Override
        public boolean match(@Nullable Object data) {
            return this.dataClazz == null || this.dataClazz.isInstance(data);
        }

        @NonNull
        public ViewItem createAssemblyItem(@NonNull ViewGroup parent) {
            return new ViewItem(this.viewFactory.createItemView(parent));
        }
    }
}

