/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.FixedItem;
import me.panpf.adapter.FixedItemManager;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ViewTypeManager;
import me.panpf.adapter.more.MoreFixedItem;
import me.panpf.adapter.more.MoreItemFactory;

public class ItemManager {
    @NonNull
    private AssemblyAdapter adapter;
    @NonNull
    private ViewTypeManager<Object> viewTypeManager = new ViewTypeManager();
    @NonNull
    private FixedItemManager headerItemManager = new FixedItemManager();
    @NonNull
    private ArrayList<ItemFactory> itemFactoryList = new ArrayList();
    @NonNull
    private FixedItemManager footerItemManager = new FixedItemManager();
    @Nullable
    private MoreFixedItem moreFixedItem;
    @Nullable
    private List dataList;
    private boolean notifyOnChange = true;

    public ItemManager(@NonNull AssemblyAdapter adapter) {
        this.adapter = adapter;
    }

    public ItemManager(@NonNull AssemblyAdapter adapter, @Nullable List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    public ItemManager(@NonNull AssemblyAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    @NonNull
    public AssemblyAdapter getAdapter() {
        return this.adapter;
    }

    public void addItemFactory(@NonNull ItemFactory itemFactory) {
        if (itemFactory == null || this.viewTypeManager.isLocked()) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        this.itemFactoryList.add(itemFactory);
        int viewType = this.viewTypeManager.add(itemFactory);
        itemFactory.attachToAdapter(this.adapter, viewType);
    }

    @NonNull
    public ArrayList<ItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    @NonNull
    public <DATA> FixedItem<DATA> addHeaderItem(@NonNull FixedItem<DATA> fixedItem) {
        if (fixedItem == null || this.viewTypeManager.isLocked()) {
            throw new IllegalArgumentException("item is null or item factory list locked");
        }
        if (fixedItem.isAttached()) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        int viewType = this.viewTypeManager.add(fixedItem);
        this.headerItemManager.add(fixedItem);
        ItemFactory<DATA> itemFactory = fixedItem.getItemFactory();
        itemFactory.attachToAdapter(this.adapter, viewType);
        fixedItem.attachToAdapter(this, true);
        return fixedItem;
    }

    @NonNull
    public <DATA> FixedItem<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.addHeaderItem(new FixedItem<DATA>(itemFactory, data));
    }

    @NonNull
    public <DATA> FixedItem<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.addHeaderItem(new FixedItem<Object>(itemFactory, null));
    }

    @NonNull
    public FixedItemManager getHeaderItemManager() {
        return this.headerItemManager;
    }

    @NonNull
    public <DATA> FixedItem<DATA> addFooterItem(@NonNull FixedItem<DATA> fixedItem) {
        if (this.viewTypeManager.isLocked()) {
            throw new IllegalArgumentException("item is null or item factory list locked");
        }
        if (fixedItem.isAttached()) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        int viewType = this.viewTypeManager.add(fixedItem);
        this.footerItemManager.add(fixedItem);
        ItemFactory<DATA> itemFactory = fixedItem.getItemFactory();
        itemFactory.attachToAdapter(this.adapter, viewType);
        fixedItem.attachToAdapter(this, false);
        return fixedItem;
    }

    @NonNull
    public <DATA> FixedItem<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.addFooterItem(new FixedItem<DATA>(itemFactory, data));
    }

    @NonNull
    public <DATA> FixedItem<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.addFooterItem(new FixedItem<Object>(itemFactory, null));
    }

    @NonNull
    public FixedItemManager getFooterItemManager() {
        return this.footerItemManager;
    }

    void fixedItemEnabledChanged(@NonNull FixedItem fixedItem) {
        if (fixedItem == null || fixedItem.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (fixedItem.isHeader()) {
            if (this.headerItemManager.itemEnabledChanged() && this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else if (this.footerItemManager.itemEnabledChanged() && this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @NonNull
    public <DATA> MoreFixedItem<DATA> setMoreItem(@NonNull MoreFixedItem<DATA> fixedItem) {
        if (this.viewTypeManager.isLocked()) {
            throw new IllegalArgumentException("item is null or item factory list locked");
        }
        if (fixedItem.isAttached()) {
            throw new IllegalArgumentException("Cannot be added repeatedly");
        }
        if (this.moreFixedItem != null) {
            throw new IllegalStateException("MoreItem cannot be set repeatedly");
        }
        int viewType = this.viewTypeManager.add(fixedItem);
        ItemFactory itemFactory = fixedItem.getItemFactory();
        itemFactory.loadMoreFinished(false);
        itemFactory.attachToAdapter(this.adapter, viewType);
        fixedItem.attachToAdapter(this, false);
        this.moreFixedItem = fixedItem;
        return fixedItem;
    }

    @NonNull
    public <DATA> MoreFixedItem<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.setMoreItem(new MoreFixedItem<DATA>(itemFactory, data));
    }

    @NonNull
    public <DATA> MoreFixedItem<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory) {
        return this.setMoreItem(new MoreFixedItem<Object>((MoreItemFactory<Object>)itemFactory, null));
    }

    @Nullable
    public MoreFixedItem getMoreFixedItem() {
        return this.moreFixedItem;
    }

    public boolean hasMoreFooter() {
        return this.moreFixedItem != null && this.moreFixedItem.isEnabled();
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(@Nullable List dataList) {
        ItemManager itemManager = this;
        synchronized (itemManager) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nullable Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        ItemManager itemManager = this;
        synchronized (itemManager) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        ItemManager itemManager = this;
        synchronized (itemManager) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@Nullable Object object, int index) {
        if (object == null) {
            return;
        }
        ItemManager itemManager = this;
        synchronized (itemManager) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull Object object) {
        if (object == null) {
            return;
        }
        ItemManager itemManager = this;
        synchronized (itemManager) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ItemManager itemManager = this;
        synchronized (itemManager) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@NonNull Comparator comparator) {
        ItemManager itemManager = this;
        synchronized (itemManager) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    public int getItemCount() {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int dataCount = this.getDataCount();
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        if (dataCount > 0) {
            return headerItemCount + dataCount + footerItemCount + (this.hasMoreFooter() ? 1 : 0);
        }
        return headerItemCount + footerItemCount;
    }

    public int getViewTypeCount() {
        if (!this.viewTypeManager.isLocked()) {
            this.viewTypeManager.lock();
        }
        return this.viewTypeManager.getCount();
    }

    @NonNull
    public ItemFactory getItemFactoryByViewType(int viewType) {
        Object value = this.viewTypeManager.get(viewType);
        if (value instanceof ItemFactory) {
            return (ItemFactory)value;
        }
        if (value instanceof FixedItem) {
            return ((FixedItem)value).getItemFactory();
        }
        if (value != null) {
            throw new IllegalArgumentException("Unknown viewType value. viewType=" + viewType + ", value=" + value);
        }
        throw new IllegalArgumentException("Unknown viewType. viewType=" + viewType);
    }

    @NonNull
    public ItemFactory getItemFactoryByPosition(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemManager.getItemInEnabledList(positionInHeaderList).getItemFactory();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getData(positionInDataList);
            for (ItemFactory itemFactory : this.itemFactoryList) {
                if (!itemFactory.match(dataObject)) continue;
                return itemFactory;
            }
            throw new IllegalStateException(String.format("Didn't find suitable ItemFactory. positionInDataList=%d, dataObject=%s", positionInDataList, dataObject != null ? dataObject.toString() : null));
        }
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemManager.getItemInEnabledList(positionInFooterList).getItemFactory();
        }
        if (this.moreFixedItem != null && dataCount > 0 && this.hasMoreFooter() && position == this.getItemCount() - 1) {
            return this.moreFixedItem.getItemFactory();
        }
        throw new IllegalStateException("Not found ItemFactory by position: " + position);
    }

    @Nullable
    public Object getItemDataByPosition(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemManager.getItemInEnabledList(positionInHeaderList).getData();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            return this.getData(positionInDataList);
        }
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemManager.getItemInEnabledList(positionInFooterList).getData();
        }
        if (dataCount > 0 && this.hasMoreFooter() && position == this.getItemCount() - 1) {
            return this.moreFixedItem != null ? this.moreFixedItem.getData() : null;
        }
        throw new IllegalArgumentException("Not found item data by position: " + position);
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        if (dataCount > 0 && this.hasMoreFooter() && position == this.getItemCount() - 1) {
            return 0;
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    public boolean isHeaderItem(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        return position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0;
    }

    public boolean isBodyItem(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerEndPosition = headerItemCount - 1;
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        return position >= dataStartPosition && position <= dataEndPosition && dataCount > 0;
    }

    public boolean isFooterItem(int position) {
        int headerItemCount = this.headerItemManager.getEnabledItemCount();
        int headerEndPosition = headerItemCount - 1;
        int dataCount = this.getDataCount();
        int dataEndPosition = headerEndPosition + dataCount;
        int footerItemCount = this.footerItemManager.getEnabledItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        return position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0;
    }

    public boolean isMoreFooterItem(int position) {
        int dataCount = this.getDataCount();
        return dataCount > 0 && this.hasMoreFooter() && position == this.getItemCount() - 1;
    }
}

