/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import me.panpf.adapter.FixedItem;

public class FixedItemManager {
    @Nullable
    private ArrayList<FixedItem> itemList;
    @Nullable
    private ArrayList<FixedItem> enabledItemList;

    public void add(@NonNull FixedItem fixedItem) {
        ArrayList<FixedItem<Object>> allList = this.itemList;
        if (allList == null) {
            allList = new ArrayList();
            this.itemList = allList;
        }
        fixedItem.setPositionInPartItemList(allList.size());
        allList.add(fixedItem);
        this.refreshEnabledList();
    }

    private void refreshEnabledList() {
        ArrayList<FixedItem> allList = this.itemList;
        if (allList != null) {
            ArrayList<FixedItem<Object>> enabledList = this.enabledItemList;
            if (enabledList == null) {
                enabledList = new ArrayList();
                this.enabledItemList = enabledList;
            } else {
                enabledList.clear();
            }
            for (FixedItem fixedItem : allList) {
                if (!fixedItem.isEnabled()) continue;
                fixedItem.setPositionInPartList(enabledList.size());
                enabledList.add(fixedItem);
            }
        }
    }

    boolean itemEnabledChanged() {
        this.refreshEnabledList();
        return true;
    }

    public int getItemCount() {
        return this.itemList != null ? this.itemList.size() : 0;
    }

    @NonNull
    public FixedItem getItem(int index) {
        if (this.itemList != null) {
            return this.itemList.get(index);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }

    @NonNull
    FixedItem getItemByClass(@NonNull Class clazz, int number) {
        if (this.itemList != null) {
            int currentNumber = 0;
            for (FixedItem fixedItem : this.itemList) {
                if (!clazz.equals(fixedItem.getItemFactory().getClass())) continue;
                if (currentNumber == number) {
                    return fixedItem;
                }
                ++currentNumber;
            }
        }
        throw new IllegalArgumentException("Not found Item by class=" + clazz.toString() + " and number=" + number);
    }

    @NonNull
    FixedItem getItemByClass(@NonNull Class clazz) {
        return this.getItemByClass(clazz, 0);
    }

    void setItemData(int index, @Nullable Object data) {
        this.getItem(index).setData(data);
    }

    boolean isItemEnabled(int index) {
        return this.getItem(index).isEnabled();
    }

    void setItemEnabled(int index, boolean enabled) {
        this.getItem(index).setEnabled(enabled);
    }

    int getEnabledItemCount() {
        return this.enabledItemList != null ? this.enabledItemList.size() : 0;
    }

    @NonNull
    FixedItem getItemInEnabledList(int index) {
        if (this.enabledItemList != null) {
            return this.enabledItemList.get(index);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: 0");
    }
}

