/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.FixedItem;
import me.panpf.adapter.Item;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemManager;
import me.panpf.adapter.more.MoreFixedItem;
import me.panpf.adapter.more.MoreItemFactory;

public class AssemblyListAdapter
extends BaseAdapter
implements AssemblyAdapter {
    @NonNull
    private ItemManager itemManager;

    public AssemblyListAdapter() {
        this.itemManager = new ItemManager(this);
    }

    public AssemblyListAdapter(@Nullable List dataList) {
        this.itemManager = new ItemManager((AssemblyAdapter)this, dataList);
    }

    public AssemblyListAdapter(@Nullable Object[] dataArray) {
        this.itemManager = new ItemManager((AssemblyAdapter)this, dataArray);
    }

    @Override
    public <DATA> void addItemFactory(@NonNull ItemFactory<DATA> itemFactory) {
        this.itemManager.addItemFactory(itemFactory);
    }

    @Override
    @NonNull
    public List<ItemFactory> getItemFactoryList() {
        return this.itemManager.getItemFactoryList();
    }

    @Override
    @NonNull
    public <DATA> FixedItem<DATA> addHeaderItem(@NonNull FixedItem<DATA> fixedItem) {
        return this.itemManager.addHeaderItem(fixedItem);
    }

    @Override
    @NonNull
    public <DATA> FixedItem<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.itemManager.addHeaderItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <DATA> FixedItem<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.itemManager.addHeaderItem(itemFactory);
    }

    @Override
    @NonNull
    public FixedItem getHeaderItemByClass(@NonNull Class clazz, int number) {
        return this.itemManager.getHeaderItemManager().getItemByClass(clazz, number);
    }

    @Override
    @NonNull
    public FixedItem getHeaderItemByClass(@NonNull Class clazz) {
        return this.itemManager.getHeaderItemManager().getItemByClass(clazz);
    }

    @Override
    @NonNull
    public FixedItem getHeaderItem(int positionInHeaderItemList) {
        return this.itemManager.getHeaderItemManager().getItem(positionInHeaderItemList);
    }

    @Override
    @Nullable
    public Object getHeaderItemData(int positionInHeaderItemList) {
        return this.itemManager.getHeaderItemManager().getItem(positionInHeaderItemList).getData();
    }

    @Override
    public void setHeaderItemData(int positionInHeaderItemList, @Nullable Object data) {
        this.itemManager.getHeaderItemManager().setItemData(positionInHeaderItemList, data);
    }

    @Override
    public boolean isHeaderItemEnabled(int positionInHeaderItemList) {
        return this.itemManager.getHeaderItemManager().isItemEnabled(positionInHeaderItemList);
    }

    @Override
    public void setHeaderItemEnabled(int positionInHeaderItemList, boolean enabled) {
        this.itemManager.getHeaderItemManager().setItemEnabled(positionInHeaderItemList, enabled);
    }

    @Override
    public int getHeaderCount() {
        return this.itemManager.getHeaderItemManager().getEnabledItemCount();
    }

    @Override
    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.itemManager.getHeaderItemManager().getItemInEnabledList(positionInHeaderList).getData();
    }

    @Override
    @NonNull
    public <DATA> FixedItem<DATA> addFooterItem(@NonNull FixedItem<DATA> fixedItem) {
        return this.itemManager.addFooterItem(fixedItem);
    }

    @Override
    @NonNull
    public <DATA> FixedItem<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.itemManager.addFooterItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <DATA> FixedItem<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.itemManager.addFooterItem(itemFactory);
    }

    @Override
    @NonNull
    public FixedItem getFooterItemByClass(@NonNull Class clazz, int number) {
        return this.itemManager.getFooterItemManager().getItemByClass(clazz, number);
    }

    @Override
    @NonNull
    public FixedItem getFooterItemByClass(@NonNull Class clazz) {
        return this.itemManager.getFooterItemManager().getItemByClass(clazz);
    }

    @Override
    @NonNull
    public FixedItem getFooterItem(int positionInFooterItemList) {
        return this.itemManager.getFooterItemManager().getItem(positionInFooterItemList);
    }

    @Override
    @Nullable
    public Object getFooterItemData(int positionInFooterItemList) {
        return this.itemManager.getFooterItemManager().getItem(positionInFooterItemList).getData();
    }

    @Override
    public void setFooterItemData(int positionInFooterItemList, @Nullable Object data) {
        this.itemManager.getFooterItemManager().setItemData(positionInFooterItemList, data);
    }

    @Override
    public boolean isFooterItemEnabled(int positionInFooterItemList) {
        return this.itemManager.getFooterItemManager().isItemEnabled(positionInFooterItemList);
    }

    @Override
    public void setFooterItemEnabled(int positionInFooterItemList, boolean enabled) {
        this.itemManager.getFooterItemManager().setItemEnabled(positionInFooterItemList, enabled);
    }

    @Override
    public int getFooterCount() {
        return this.itemManager.getFooterItemManager().getEnabledItemCount();
    }

    @Override
    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.itemManager.getFooterItemManager().getItemInEnabledList(positionInFooterList).getData();
    }

    @Override
    @NonNull
    public <DATA> MoreFixedItem<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.itemManager.setMoreItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <DATA> MoreFixedItem<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory) {
        return this.itemManager.setMoreItem(itemFactory);
    }

    @Override
    @NonNull
    public <DATA> MoreFixedItem<DATA> setMoreItem(@NonNull MoreFixedItem<DATA> moreFixedItem) {
        return this.itemManager.setMoreItem(moreFixedItem);
    }

    @Override
    @Nullable
    public MoreFixedItem getMoreItem() {
        return this.itemManager.getMoreFixedItem();
    }

    @Override
    public boolean hasMoreFooter() {
        return this.itemManager.hasMoreFooter();
    }

    @Override
    public void setMoreItemEnabled(boolean enabled) {
        MoreFixedItem moreFixedItem = this.itemManager.getMoreFixedItem();
        if (moreFixedItem != null) {
            moreFixedItem.setEnabled(enabled);
        }
    }

    @Override
    public void loadMoreFinished(boolean end) {
        MoreFixedItem moreFixedItem = this.itemManager.getMoreFixedItem();
        if (moreFixedItem != null) {
            moreFixedItem.loadMoreFinished(end);
        }
    }

    @Override
    public void loadMoreFailed() {
        MoreFixedItem moreFixedItem = this.itemManager.getMoreFixedItem();
        if (moreFixedItem != null) {
            moreFixedItem.loadMoreFailed();
        }
    }

    @Override
    @Nullable
    public List getDataList() {
        return this.itemManager.getDataList();
    }

    @Override
    public void setDataList(@Nullable List dataList) {
        this.itemManager.setDataList(dataList);
    }

    @Override
    public void addAll(@Nullable Collection collection) {
        this.itemManager.addAll(collection);
    }

    @Override
    public void addAll(Object ... items) {
        this.itemManager.addAll(items);
    }

    @Override
    public void insert(@NonNull Object object, int index) {
        this.itemManager.insert(object, index);
    }

    @Override
    public void remove(@NonNull Object object) {
        this.itemManager.remove(object);
    }

    @Override
    public void clear() {
        this.itemManager.clear();
    }

    @Override
    public void sort(@NonNull Comparator comparator) {
        this.itemManager.sort(comparator);
    }

    @Override
    public int getDataCount() {
        return this.itemManager.getDataCount();
    }

    @Override
    @Nullable
    public Object getData(int positionInDataList) {
        return this.itemManager.getData(positionInDataList);
    }

    @Override
    public int getItemCount() {
        return this.itemManager.getItemCount();
    }

    @Override
    @Nullable
    public Object getItem(int position) {
        return this.itemManager.getItemDataByPosition(position);
    }

    @Override
    public int getPositionInPart(int position) {
        return this.itemManager.getPositionInPart(position);
    }

    @Override
    public boolean isHeaderItem(int position) {
        return this.itemManager.isHeaderItem(position);
    }

    @Override
    public boolean isBodyItem(int position) {
        return this.itemManager.isBodyItem(position);
    }

    @Override
    public boolean isFooterItem(int position) {
        return this.itemManager.isFooterItem(position);
    }

    @Override
    public boolean isMoreFooterItem(int position) {
        return this.itemManager.isMoreFooterItem(position);
    }

    @Override
    public int getSpanSize(int position) {
        return this.itemManager.getItemFactoryByPosition(position).getSpanSize();
    }

    @Override
    @NonNull
    public ItemFactory getItemFactoryByPosition(int position) {
        return this.itemManager.getItemFactoryByPosition(position);
    }

    @Override
    @NonNull
    public ItemFactory getItemFactoryByViewType(int viewType) {
        return this.itemManager.getItemFactoryByViewType(viewType);
    }

    @Override
    public boolean isNotifyOnChange() {
        return this.itemManager.isNotifyOnChange();
    }

    @Override
    public void setNotifyOnChange(boolean notifyOnChange) {
        this.itemManager.setNotifyOnChange(notifyOnChange);
    }

    public int getCount() {
        return this.itemManager.getItemCount();
    }

    public long getItemId(int position) {
        return position;
    }

    public int getViewTypeCount() {
        return this.itemManager.getViewTypeCount();
    }

    public int getItemViewType(int position) {
        return this.itemManager.getItemFactoryByPosition(position).getViewType();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Item item;
        if (convertView == null) {
            item = this.createItem(parent, this.getItemViewType(position));
            convertView = item.getItemView();
            convertView.setTag((Object)item);
        } else {
            item = (Item)convertView.getTag();
        }
        this.bindItem(item, position);
        return convertView;
    }

    @NonNull
    private Item createItem(@NonNull ViewGroup parent, int viewType) {
        ItemFactory itemFactory = this.itemManager.getItemFactoryByViewType(viewType);
        return itemFactory.dispatchCreateItem(parent);
    }

    private void bindItem(@NonNull Item item, int position) {
        Object itemObject = this.getItem(position);
        item.setData(position, itemObject);
    }
}

