/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemManager;

public class FixedItem<DATA> {
    @NonNull
    private ItemFactory<DATA> itemFactory;
    @Nullable
    private DATA data;
    @Nullable
    private ItemManager itemManager;
    private boolean header;
    private boolean enabled = true;
    private int positionInPartList;
    private int positionInPartItemList;

    public FixedItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        this.itemFactory = itemFactory;
        this.data = data;
    }

    public FixedItem(@NonNull ItemFactory<DATA> itemFactory) {
        this.itemFactory = itemFactory;
    }

    @Nullable
    public DATA getData() {
        return this.data;
    }

    public void setData(@Nullable DATA data) {
        this.data = data;
        AssemblyAdapter adapter = this.itemFactory.getAdapter();
        if (adapter != null && adapter.isNotifyOnChange()) {
            adapter.notifyDataSetChanged();
        }
    }

    @NonNull
    public ItemFactory<DATA> getItemFactory() {
        return this.itemFactory;
    }

    public boolean isAttached() {
        return this.itemManager != null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.enableChanged();
    }

    void attachToAdapter(@NonNull ItemManager itemManager, boolean header) {
        this.itemManager = itemManager;
        this.header = header;
    }

    protected void enableChanged() {
        if (this.itemManager != null) {
            this.itemManager.fixedItemEnabledChanged(this);
        }
    }

    public boolean isHeader() {
        return this.header;
    }

    public int getPositionInPartList() {
        return this.positionInPartList;
    }

    public void setPositionInPartList(int positionInPartList) {
        this.positionInPartList = positionInPartList;
    }

    public int getPositionInPartItemList() {
        return this.positionInPartItemList;
    }

    public void setPositionInPartItemList(int positionInPartItemList) {
        this.positionInPartItemList = positionInPartItemList;
    }
}

