/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.Item;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemHolder;
import me.panpf.adapter.expandable.ExpandableItemActor;
import me.panpf.adapter.expandable.ExpandableItemStorage;
import me.panpf.adapter.more.MoreItemFactory;
import me.panpf.adapter.more.MoreItemHolder;

public class AssemblyExpandableAdapter
extends BaseExpandableListAdapter
implements AssemblyAdapter {
    @NonNull
    private ExpandableItemStorage storage;
    @NonNull
    private ExpandableItemActor actor = new ExpandableItemActor(this);
    private ExpandCallback expandCallback;

    public AssemblyExpandableAdapter() {
        this.storage = new ExpandableItemStorage(this);
    }

    public AssemblyExpandableAdapter(@Nullable List dataList) {
        this.storage = new ExpandableItemStorage((AssemblyAdapter)this, dataList);
    }

    public AssemblyExpandableAdapter(@Nullable Object[] dataArray) {
        this.storage = new ExpandableItemStorage((AssemblyAdapter)this, dataArray);
    }

    @Override
    public <DATA> void addItemFactory(@NonNull ItemFactory<DATA> itemFactory) {
        this.storage.addItemFactory(itemFactory);
    }

    public <DATA> void addGroupItemFactory(@NonNull ItemFactory<DATA> groupItemFactory) {
        this.storage.addItemFactory(groupItemFactory);
    }

    public <DATA> void addChildItemFactory(@NonNull ItemFactory<DATA> childItemFactory) {
        this.storage.addChildItemFactory(childItemFactory);
    }

    @Override
    @Nullable
    public List<ItemFactory> getItemFactoryList() {
        return this.storage.getItemFactoryList();
    }

    @Nullable
    public List<ItemFactory> getGroupItemFactoryList() {
        return this.storage.getItemFactoryList();
    }

    @Nullable
    public List<ItemFactory> getChildItemFactoryList() {
        return this.storage.getChildItemFactoryList();
    }

    @Override
    public int getItemFactoryCount() {
        return this.storage.getItemFactoryCount();
    }

    public int getGroupItemFactoryCount() {
        return this.storage.getItemFactoryCount();
    }

    public int getChildItemFactoryCount() {
        return this.storage.getChildItemFactoryCount();
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.storage.addHeaderItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.storage.addHeaderItem(itemFactory);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemHolder<DATA> itemHolder) {
        return this.storage.addHeaderItem(itemHolder);
    }

    @Override
    public List<ItemHolder> getHeaderItemList() {
        return this.storage.getHeaderItemList();
    }

    @Override
    public int getHeaderItemCount() {
        return this.storage.getHeaderItemCount();
    }

    @Override
    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.storage.getHeaderData(positionInHeaderList);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.storage.addFooterItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.storage.addHeaderItem(itemFactory);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemHolder<DATA> itemHolder) {
        return this.storage.addFooterItem(itemHolder);
    }

    @Override
    public List<ItemHolder> getFooterItemList() {
        return this.storage.getFooterItemList();
    }

    @Override
    public int getFooterItemCount() {
        return this.storage.getFooterItemCount();
    }

    @Override
    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.storage.getFooterData(positionInFooterList);
    }

    @Override
    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.storage.setMoreItem(itemFactory, data);
    }

    @Override
    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory) {
        return this.storage.setMoreItem(itemFactory);
    }

    @Override
    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemHolder<DATA> itemHolder) {
        return this.storage.setMoreItem(itemHolder);
    }

    @Override
    @Nullable
    public MoreItemHolder getMoreItemHolder() {
        return this.storage.getMoreItemHolder();
    }

    @Override
    public boolean hasMoreFooter() {
        return this.storage.hasMoreFooter();
    }

    @Override
    public void setEnabledMoreItem(boolean enabledMoreItem) {
        this.storage.setEnabledMoreItem(enabledMoreItem);
    }

    @Override
    public void loadMoreFinished(boolean loadMoreEnd) {
        this.storage.loadMoreFinished(loadMoreEnd);
    }

    @Override
    public void loadMoreFailed() {
        this.storage.loadMoreFailed();
    }

    @Override
    public List getDataList() {
        return this.storage.getDataList();
    }

    @Override
    public void setDataList(@Nullable List dataList) {
        this.storage.setDataList(dataList);
    }

    @Override
    public void addAll(@Nullable Collection collection) {
        this.storage.addAll(collection);
    }

    @Override
    public void addAll(Object ... items) {
        this.storage.addAll(items);
    }

    @Override
    public void insert(@NonNull Object object, int index) {
        this.storage.insert(object, index);
    }

    @Override
    public void remove(@NonNull Object object) {
        this.storage.remove(object);
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public void sort(@NonNull Comparator comparator) {
        this.storage.sort(comparator);
    }

    @Override
    public int getDataCount() {
        return this.storage.getDataCount();
    }

    @Override
    @Nullable
    public Object getData(int positionInDataList) {
        return this.storage.getData(positionInDataList);
    }

    @Override
    public int getItemCount() {
        return this.actor.getItemCount();
    }

    @Override
    @Nullable
    public Object getItem(int position) {
        return this.actor.getItem(position);
    }

    @Override
    public int getPositionInPart(int position) {
        return this.actor.getPositionInPart(position);
    }

    @Override
    public boolean isNotifyOnChange() {
        return this.storage.isNotifyOnChange();
    }

    @Override
    public void setNotifyOnChange(boolean notifyOnChange) {
        this.storage.setNotifyOnChange(notifyOnChange);
    }

    @Override
    public int getSpanSize(int position) {
        return this.actor.getSpanSize(position);
    }

    public int getGroupCount() {
        return this.actor.getItemCount();
    }

    @Nullable
    public Object getGroup(int groupPosition) {
        return this.actor.getItem(groupPosition);
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    public int getGroupTypeCount() {
        return this.storage.getViewTypeCount();
    }

    public int getGroupType(int groupPosition) {
        return this.actor.getItemViewType(groupPosition);
    }

    public int getChildrenCount(int groupPosition) {
        return this.actor.getChildrenCount(groupPosition);
    }

    @Nullable
    public Object getChild(int groupPosition, int childPosition) {
        return this.actor.getChild(groupPosition, childPosition);
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public int getChildTypeCount() {
        return this.storage.getChildTypeCount();
    }

    public int getChildType(int groupPosition, int childPosition) {
        return this.actor.getChildType(groupPosition, childPosition);
    }

    public boolean hasStableIds() {
        return this.expandCallback != null && this.expandCallback.hasStableIds();
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return this.expandCallback != null && this.expandCallback.isChildSelectable(groupPosition, childPosition);
    }

    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        Item groupItem;
        if (convertView == null) {
            groupItem = this.createGroupItem(parent, this.getGroupType(groupPosition));
            convertView = groupItem.getItemView();
            convertView.setTag((Object)groupItem);
        } else {
            groupItem = (Item)convertView.getTag();
        }
        this.bindGroupItem(groupItem, isExpanded, groupPosition);
        return convertView;
    }

    private Item createGroupItem(ViewGroup parent, int viewType) {
        Object itemObject = this.storage.getItemFactoryByViewType(viewType);
        if (itemObject instanceof ItemFactory) {
            ItemFactory itemFactory = (ItemFactory)itemObject;
            return itemFactory.dispatchCreateItem(parent);
        }
        if (itemObject instanceof ItemHolder) {
            ItemHolder itemHolder = (ItemHolder)itemObject;
            return itemHolder.getItemFactory().dispatchCreateItem(parent);
        }
        throw new IllegalStateException(String.format("Unknown groupViewType: %d, itemFactory: %s", viewType, itemObject != null ? itemObject.getClass().getName() : "null"));
    }

    private void bindGroupItem(@NonNull Item groupItem, boolean isExpanded, int groupPosition) {
        Object group = this.getGroup(groupPosition);
        groupItem.setExpanded(isExpanded);
        groupItem.setData(groupPosition, group);
    }

    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        Item childItem;
        if (convertView == null) {
            childItem = this.createChildItem(parent, this.getChildType(groupPosition, childPosition));
            convertView = childItem.getItemView();
            convertView.setTag((Object)childItem);
        } else {
            childItem = (Item)convertView.getTag();
        }
        this.bindChildItem(childItem, groupPosition, childPosition, isLastChild);
        return convertView;
    }

    private Item createChildItem(ViewGroup parent, int viewType) {
        Object itemObject = this.storage.getChildItemFactoryByViewType(viewType);
        if (itemObject instanceof ItemFactory) {
            ItemFactory itemFactory = (ItemFactory)itemObject;
            return itemFactory.dispatchCreateItem(parent);
        }
        throw new IllegalStateException(String.format("Unknown childViewType: %d, itemFactory: %s", viewType, itemObject != null ? itemObject.getClass().getName() : "null"));
    }

    private void bindChildItem(Item childItem, int groupPosition, int childPosition, boolean isLastChild) {
        Object child = this.getChild(groupPosition, childPosition);
        childItem.setGroupPosition(groupPosition);
        childItem.setLastChild(isLastChild);
        childItem.setData(childPosition, child);
    }

    public void setExpandCallback(ExpandCallback expandCallback) {
        this.expandCallback = expandCallback;
    }

    public static interface ExpandCallback {
        public boolean hasStableIds();

        public boolean isChildSelectable(int var1, int var2);
    }
}

