/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.util.SparseIntArray;
import java.util.List;

public class FragmentArrayStatePagerAdapter
extends FragmentStatePagerAdapter {
    @NonNull
    private Fragment[] fragments;
    private int notifyNumber = 0;
    @Nullable
    private SparseIntArray notifyNumberPool;

    public FragmentArrayStatePagerAdapter(@NonNull FragmentManager fm, @NonNull Fragment[] fragments) {
        super(fm);
        this.fragments = fragments;
    }

    public FragmentArrayStatePagerAdapter(@NonNull FragmentManager fm, @NonNull List<Fragment> fragments) {
        this(fm, fragments.toArray(new Fragment[fragments.size()]));
    }

    @NonNull
    public Fragment[] getFragments() {
        return this.fragments;
    }

    public void setFragments(@NonNull Fragment[] fragments) {
        this.fragments = fragments;
        this.notifyDataSetChanged();
    }

    public Fragment getItem(int position) {
        return this.fragments[position];
    }

    public int getCount() {
        return this.fragments != null ? this.fragments.length : 0;
    }

    public boolean isEnabledPositionNoneOnNotifyDataSetChanged() {
        return this.notifyNumberPool != null;
    }

    public void setEnabledPositionNoneOnNotifyDataSetChanged(boolean enabled) {
        if (enabled) {
            this.notifyNumberPool = new SparseIntArray();
            this.notifyNumber = 0;
        } else {
            this.notifyNumberPool = null;
        }
    }

    public void notifyDataSetChanged() {
        if (this.notifyNumberPool != null) {
            ++this.notifyNumber;
        }
        super.notifyDataSetChanged();
    }

    public int getItemPosition(@NonNull Object object) {
        if (this.notifyNumberPool != null && this.notifyNumberPool.get(object.hashCode()) != this.notifyNumber) {
            this.notifyNumberPool.put(object.hashCode(), this.notifyNumber);
            return -2;
        }
        return super.getItemPosition(object);
    }
}

