/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.PagerItemActor;
import me.panpf.adapter.pager.PagerItemHolder;
import me.panpf.adapter.pager.PagerItemStorage;

public class AssemblyPagerAdapter
extends PagerAdapter {
    @NonNull
    private PagerItemStorage storage;
    @NonNull
    private PagerItemActor actor = new PagerItemActor(this);
    private int notifyNumber = 0;
    @Nullable
    private SparseIntArray notifyNumberPool;

    public AssemblyPagerAdapter() {
        this.storage = new PagerItemStorage(this);
    }

    public AssemblyPagerAdapter(@Nullable List dataList) {
        this.storage = new PagerItemStorage(this, dataList);
    }

    public AssemblyPagerAdapter(@Nullable Object[] dataArray) {
        this.storage = new PagerItemStorage(this, dataArray);
    }

    public void addItemFactory(@NonNull AssemblyPagerItemFactory itemFactory) {
        this.storage.addItemFactory(itemFactory);
    }

    @Nullable
    public List<AssemblyPagerItemFactory> getItemFactoryList() {
        return this.storage.getItemFactoryList();
    }

    public int getItemFactoryCount() {
        return this.storage.getItemFactoryCount();
    }

    @NonNull
    public PagerItemHolder addHeaderItem(@NonNull AssemblyPagerItemFactory itemFactory, @Nullable Object data) {
        return this.storage.addHeaderItem(itemFactory, data);
    }

    @NonNull
    public PagerItemHolder addHeaderItem(@NonNull AssemblyPagerItemFactory itemFactory) {
        return this.storage.addHeaderItem(itemFactory);
    }

    @Nullable
    public List<PagerItemHolder> getHeaderItemList() {
        return this.storage.getHeaderItemList();
    }

    public int getHeaderItemCount() {
        return this.storage.getHeaderItemCount();
    }

    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.storage.getHeaderData(positionInHeaderList);
    }

    @NonNull
    public PagerItemHolder addFooterItem(@NonNull AssemblyPagerItemFactory itemFactory, @Nullable Object data) {
        return this.storage.addFooterItem(itemFactory, data);
    }

    @NonNull
    public PagerItemHolder addFooterItem(@NonNull AssemblyPagerItemFactory itemFactory) {
        return this.storage.addFooterItem(itemFactory);
    }

    @Nullable
    public List<PagerItemHolder> getFooterItemList() {
        return this.storage.getFooterItemList();
    }

    public int getFooterItemCount() {
        return this.storage.getFooterItemCount();
    }

    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.storage.getFooterData(positionInFooterList);
    }

    @Nullable
    public List getDataList() {
        return this.storage.getDataList();
    }

    public void setDataList(@Nullable List dataList) {
        this.storage.setDataList(dataList);
    }

    public void addAll(@Nullable Collection collection) {
        this.storage.addAll(collection);
    }

    public void addAll(Object ... items) {
        this.storage.addAll(items);
    }

    public void insert(@NonNull Object object, int index) {
        this.storage.insert(object, index);
    }

    public void remove(@NonNull Object object) {
        this.storage.remove(object);
    }

    public void clear() {
        this.storage.clear();
    }

    public void sort(@NonNull Comparator comparator) {
        this.storage.sort(comparator);
    }

    public int getDataCount() {
        return this.storage.getDataCount();
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.storage.getData(positionInDataList);
    }

    public int getCount() {
        return this.actor.getItemCount();
    }

    public int getPositionInPart(int position) {
        return this.actor.getPositionInPart(position);
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        return this.actor.getItem(container, position);
    }

    public boolean isNotifyOnChange() {
        return this.storage.isNotifyOnChange();
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.storage.setNotifyOnChange(notifyOnChange);
    }

    public boolean isEnabledPositionNoneOnNotifyDataSetChanged() {
        return this.notifyNumberPool != null;
    }

    public void setEnabledPositionNoneOnNotifyDataSetChanged(boolean enabled) {
        if (enabled) {
            this.notifyNumberPool = new SparseIntArray();
            this.notifyNumber = 0;
        } else {
            this.notifyNumberPool = null;
        }
    }

    public void notifyDataSetChanged() {
        if (this.notifyNumberPool != null) {
            ++this.notifyNumber;
        }
        super.notifyDataSetChanged();
    }

    public int getItemPosition(@NonNull Object object) {
        if (this.notifyNumberPool != null && this.notifyNumberPool.get(object.hashCode()) != this.notifyNumber) {
            this.notifyNumberPool.put(object.hashCode(), this.notifyNumber);
            return -2;
        }
        return super.getItemPosition(object);
    }
}

