/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemHolder;
import me.panpf.adapter.more.MoreItemHolder;

public class ItemActor {
    @NonNull
    private AssemblyAdapter adapter;

    public ItemActor(@NonNull AssemblyAdapter adapter) {
        this.adapter = adapter;
    }

    public int getItemCount() {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int dataCount = this.adapter.getDataCount();
        int footerItemCount = this.adapter.getFooterItemCount();
        if (dataCount > 0) {
            return headerItemCount + dataCount + footerItemCount + (this.adapter.hasMoreFooter() ? 1 : 0);
        }
        return headerItemCount + footerItemCount;
    }

    @Nullable
    public Object getItem(int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.adapter.getHeaderData(positionInHeaderList);
        }
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            return this.adapter.getData(positionInDataList);
        }
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.adapter.getFooterData(positionInFooterList);
        }
        if (dataCount > 0 && this.adapter.hasMoreFooter() && position == this.getItemCount() - 1) {
            MoreItemHolder moreItemHolder = this.adapter.getMoreItemHolder();
            return moreItemHolder != null ? moreItemHolder.getData() : null;
        }
        return null;
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        if (dataCount > 0 && this.adapter.hasMoreFooter() && position == this.adapter.getItemCount() - 1) {
            return 0;
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    public int getSpanSize(int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        List<ItemHolder> headerItemList = this.adapter.getHeaderItemList();
        if (headerItemList != null && position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return headerItemList.get(positionInHeaderList).getItemFactory().getSpanSize();
        }
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        List<ItemFactory> itemFactoryList = this.adapter.getItemFactoryList();
        if (itemFactoryList != null && position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.adapter.getData(positionInDataList);
            int size = itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                ItemFactory itemFactory = itemFactoryList.get(w);
                if (!itemFactory.match(dataObject)) continue;
                return itemFactory.getSpanSize();
            }
            throw new IllegalStateException(String.format("Didn't find suitable ItemFactory. positionInDataList=%d, dataObject=%s", positionInDataList, dataObject != null ? dataObject.getClass().getName() : null));
        }
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        List<ItemHolder> footerItemList = this.adapter.getHeaderItemList();
        if (footerItemList != null && position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return footerItemList.get(positionInFooterList).getItemFactory().getSpanSize();
        }
        MoreItemHolder moreItemHolder = this.adapter.getMoreItemHolder();
        if (moreItemHolder != null && dataCount > 0 && this.adapter.hasMoreFooter() && position == this.getItemCount() - 1) {
            return ((ItemHolder)moreItemHolder).getItemFactory().getSpanSize();
        }
        return 1;
    }

    public int getItemViewType(int position) {
        int headerItemCount = this.adapter.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        List<ItemHolder> headerItemList = this.adapter.getHeaderItemList();
        if (headerItemList != null && position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return headerItemList.get(positionInHeaderList).getItemFactory().getItemType();
        }
        List<ItemFactory> itemFactoryList = this.adapter.getItemFactoryList();
        int dataCount = this.adapter.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (itemFactoryList != null && position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.adapter.getData(positionInDataList);
            int size = itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                ItemFactory itemFactory = itemFactoryList.get(w);
                if (!itemFactory.match(dataObject)) continue;
                return itemFactory.getItemType();
            }
            throw new IllegalStateException(String.format("Didn't find suitable ItemFactory. positionInDataList=%d, dataObject=%s", positionInDataList, dataObject != null ? dataObject.toString() : null));
        }
        List<ItemHolder> footerItemList = this.adapter.getFooterItemList();
        int footerItemCount = this.adapter.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (footerItemList != null && position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return footerItemList.get(positionInFooterList).getItemFactory().getItemType();
        }
        MoreItemHolder moreItemHolder = this.adapter.getMoreItemHolder();
        if (moreItemHolder != null && dataCount > 0 && this.adapter.hasMoreFooter() && position == this.getItemCount() - 1) {
            return ((ItemHolder)moreItemHolder).getItemFactory().getItemType();
        }
        throw new IllegalStateException("Not found match viewType, position: " + position);
    }
}

