/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.view.ViewGroup;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.Item;
import me.panpf.adapter.ItemActor;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemHolder;
import me.panpf.adapter.ItemStorage;
import me.panpf.adapter.more.MoreItemFactory;
import me.panpf.adapter.more.MoreItemHolder;
import me.panpf.adapter.recycler.RecyclerItemWrapper;

public class AssemblyRecyclerAdapter
extends RecyclerView.Adapter
implements AssemblyAdapter {
    @NonNull
    private ItemStorage storage;
    @NonNull
    private ItemActor actor = new ItemActor(this);

    public AssemblyRecyclerAdapter() {
        this.storage = new ItemStorage(this);
    }

    public AssemblyRecyclerAdapter(@Nullable List dataList) {
        this.storage = new ItemStorage((AssemblyAdapter)this, dataList);
    }

    public AssemblyRecyclerAdapter(@Nullable Object[] dataArray) {
        this.storage = new ItemStorage((AssemblyAdapter)this, dataArray);
    }

    @Override
    public <DATA> void addItemFactory(@NonNull ItemFactory<DATA> itemFactory) {
        this.storage.addItemFactory(itemFactory.setInRecycler(true));
    }

    @Override
    @Nullable
    public List<ItemFactory> getItemFactoryList() {
        return this.storage.getItemFactoryList();
    }

    @Override
    public int getItemFactoryCount() {
        return this.storage.getItemFactoryCount();
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.storage.addHeaderItem(itemFactory.setInRecycler(true), data);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addHeaderItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.storage.addHeaderItem(itemFactory.setInRecycler(true));
    }

    @Override
    @Nullable
    public List<ItemHolder> getHeaderItemList() {
        return this.storage.getHeaderItemList();
    }

    @Override
    public int getHeaderItemCount() {
        return this.storage.getHeaderItemCount();
    }

    @Override
    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.storage.getHeaderData(positionInHeaderList);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.storage.addFooterItem(itemFactory.setInRecycler(true), data);
    }

    @Override
    @NonNull
    public <DATA> ItemHolder<DATA> addFooterItem(@NonNull ItemFactory<DATA> itemFactory) {
        return this.storage.addFooterItem(itemFactory.setInRecycler(true));
    }

    @Override
    public int getFooterItemCount() {
        return this.storage.getFooterItemCount();
    }

    @Override
    @Nullable
    public List<ItemHolder> getFooterItemList() {
        return this.storage.getFooterItemList();
    }

    @Override
    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.storage.getFooterData(positionInFooterList);
    }

    @Override
    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory, @Nullable DATA data) {
        return this.storage.setMoreItem(itemFactory.setInRecycler(true), data);
    }

    @Override
    @NonNull
    public <DATA> MoreItemHolder<DATA> setMoreItem(@NonNull MoreItemFactory<DATA> itemFactory) {
        return this.storage.setMoreItem(itemFactory.setInRecycler(true));
    }

    @Override
    @Nullable
    public MoreItemHolder getMoreItemHolder() {
        return this.storage.getMoreItemHolder();
    }

    @Override
    public boolean hasMoreFooter() {
        return this.storage.hasMoreFooter();
    }

    @Override
    public void setEnabledMoreItem(boolean enabledMoreItem) {
        this.storage.setEnabledMoreItem(enabledMoreItem);
    }

    @Override
    public void loadMoreFinished(boolean loadMoreEnd) {
        this.storage.loadMoreFinished(loadMoreEnd);
    }

    @Override
    public void loadMoreFailed() {
        this.storage.loadMoreFailed();
    }

    @Override
    @Nullable
    public List getDataList() {
        return this.storage.getDataList();
    }

    @Override
    public void setDataList(@Nullable List dataList) {
        this.storage.setDataList(dataList);
    }

    @Override
    public void addAll(@Nullable Collection collection) {
        this.storage.addAll(collection);
    }

    @Override
    public void addAll(Object ... items) {
        this.storage.addAll(items);
    }

    @Override
    public void insert(@NonNull Object object, int index) {
        this.storage.insert(object, index);
    }

    @Override
    public void remove(@NonNull Object object) {
        this.storage.remove(object);
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    @Override
    public void sort(@NonNull Comparator comparator) {
        this.storage.sort(comparator);
    }

    @Override
    public int getDataCount() {
        return this.storage.getDataCount();
    }

    @Override
    @Nullable
    public Object getData(int positionInDataList) {
        return this.storage.getData(positionInDataList);
    }

    @Override
    public int getItemCount() {
        return this.actor.getItemCount();
    }

    @Override
    @Nullable
    public Object getItem(int position) {
        return this.actor.getItem(position);
    }

    @Override
    public int getPositionInPart(int position) {
        return this.actor.getPositionInPart(position);
    }

    @Override
    public boolean isNotifyOnChange() {
        return this.storage.isNotifyOnChange();
    }

    @Override
    public void setNotifyOnChange(boolean notifyOnChange) {
        this.storage.setNotifyOnChange(notifyOnChange);
    }

    @Override
    public int getSpanSize(int position) {
        return this.actor.getSpanSize(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        return this.actor.getItemViewType(position);
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        Object itemObject = this.storage.getItemFactoryByViewType(viewType);
        if (itemObject instanceof ItemFactory) {
            ItemFactory itemFactory = (ItemFactory)itemObject;
            Item item = itemFactory.dispatchCreateItem(parent);
            if (item instanceof RecyclerItemWrapper) {
                return (RecyclerItemWrapper)item;
            }
            throw new IllegalStateException(String.format("Item not RecyclerItemWrapper. itemFactory: %s", itemFactory.toString()));
        }
        if (itemObject instanceof ItemHolder) {
            ItemFactory itemFactory = ((ItemHolder)itemObject).getItemFactory();
            Item item = itemFactory.dispatchCreateItem(parent);
            if (item instanceof RecyclerItemWrapper) {
                return (RecyclerItemWrapper)item;
            }
            throw new IllegalStateException(String.format("Item not RecyclerItemWrapper. itemFactory: %s", itemFactory.toString()));
        }
        throw new IllegalStateException(String.format("Unknown viewType: %d, itemFactory: %s", viewType, itemObject != null ? itemObject.toString() : "null"));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof Item) {
            Object itemData = this.getItem(position);
            ((Item)viewHolder).setData(position, itemData);
        }
    }
}

