/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;
import java.util.LinkedList;
import java.util.List;
import me.panpf.adapter.ClickListenerHolder;
import me.panpf.adapter.LongClickListenerHolder;
import me.panpf.adapter.OnClickListener;
import me.panpf.adapter.OnLongClickListener;
import me.panpf.adapter.R;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;

public class PagerClickListenerManager<DATA> {
    @NonNull
    private List<Object> holders = new LinkedList<Object>();

    public void add(@IdRes int viewId, @NonNull OnClickListener<DATA> onClickListener) {
        this.holders.add(new ClickListenerHolder<DATA>(viewId, onClickListener));
    }

    public void add(@NonNull OnClickListener<DATA> onClickListener) {
        this.holders.add(new ClickListenerHolder<DATA>(onClickListener));
    }

    public void add(@IdRes int viewId, @NonNull OnLongClickListener<DATA> onClickListener) {
        this.holders.add(new LongClickListenerHolder<DATA>(viewId, onClickListener));
    }

    public void add(@NonNull OnLongClickListener<DATA> onClickListener) {
        this.holders.add(new LongClickListenerHolder<DATA>(onClickListener));
    }

    public void register(@NonNull AssemblyPagerItemFactory<DATA> itemFactory, @NonNull View itemView, int position, DATA data) {
        for (Object holder : this.holders) {
            int positionInPart;
            AssemblyPagerAdapter adapter;
            View targetView;
            int viewId;
            if (holder instanceof ClickListenerHolder) {
                final ClickListenerHolder clickListenerHolder = (ClickListenerHolder)holder;
                viewId = clickListenerHolder.getViewId();
                View view = targetView = viewId > 0 ? itemView.findViewById(viewId) : itemView;
                if (targetView == null) {
                    throw new IllegalArgumentException("Not found target view by id " + viewId);
                }
                adapter = itemFactory.getAdapter();
                positionInPart = adapter != null ? adapter.getPositionInPart(position) : position;
                targetView.setTag(R.id.aa_item_position, (Object)position);
                targetView.setTag(R.id.aa_item_position_in_port, (Object)positionInPart);
                targetView.setTag(R.id.aa_item_data, data);
                targetView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        clickListenerHolder.getListener().onViewClick(v.getContext(), v, (Integer)v.getTag(R.id.aa_item_position), (Integer)v.getTag(R.id.aa_item_position_in_port), v.getTag(R.id.aa_item_data));
                    }
                });
                continue;
            }
            if (!(holder instanceof LongClickListenerHolder)) continue;
            final LongClickListenerHolder longClickListenerHolder = (LongClickListenerHolder)holder;
            viewId = longClickListenerHolder.getViewId();
            View view = targetView = viewId > 0 ? itemView.findViewById(viewId) : itemView;
            if (targetView == null) {
                throw new IllegalArgumentException("Not found target view by id " + viewId);
            }
            adapter = itemFactory.getAdapter();
            positionInPart = adapter != null ? adapter.getPositionInPart(position) : position;
            targetView.setTag(R.id.aa_item_position, (Object)position);
            targetView.setTag(R.id.aa_item_position_in_port, (Object)positionInPart);
            targetView.setTag(R.id.aa_item_data, data);
            targetView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    return longClickListenerHolder.getListener().onViewLongClick(v.getContext(), v, (Integer)v.getTag(R.id.aa_item_position), (Integer)v.getTag(R.id.aa_item_position_in_port), v.getTag(R.id.aa_item_data));
                }
            });
        }
    }
}

