/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import me.panpf.adapter.AssemblyItem;
import me.panpf.adapter.AssemblyItemFactory;

public class ViewItemFactory
extends AssemblyItemFactory<Object> {
    @NonNull
    private ViewFactory viewFactory;
    @Nullable
    private Class<?> dataClazz;

    public ViewItemFactory(@NonNull ViewFactory viewFactory, @Nullable Class<?> dataClazz) {
        this.viewFactory = viewFactory;
        this.dataClazz = dataClazz;
    }

    public ViewItemFactory(@NonNull ViewFactory viewFactory) {
        this(viewFactory, null);
    }

    public ViewItemFactory(final @LayoutRes int layoutResId, @Nullable Class<?> dataClazz) {
        this(new ViewFactory(){

            @Override
            @NonNull
            public View createItemView(@NonNull ViewGroup parent) {
                return LayoutInflater.from((Context)parent.getContext()).inflate(layoutResId, parent, false);
            }
        }, dataClazz);
    }

    public ViewItemFactory(@LayoutRes int layoutResId) {
        this(layoutResId, null);
    }

    public ViewItemFactory(final @NonNull View view, @Nullable Class<?> dataClazz) {
        this(new ViewFactory(){

            @Override
            @NonNull
            public View createItemView(@NonNull ViewGroup parent) {
                return view;
            }
        }, dataClazz);
    }

    public ViewItemFactory(@NonNull View view) {
        this(view, null);
    }

    @Override
    public boolean match(@Nullable Object data) {
        return this.dataClazz == null || this.dataClazz.isInstance(data);
    }

    @NonNull
    public ViewItem createAssemblyItem(@NonNull ViewGroup parent) {
        return new ViewItem(this.viewFactory.createItemView(parent));
    }

    public class ViewItem
    extends AssemblyItem<Object> {
        ViewItem(View itemView) {
            super(itemView);
        }

        @Override
        protected void onSetData(int position, @Nullable Object o) {
        }
    }

    public static interface ViewFactory {
        @NonNull
        public View createItemView(@NonNull ViewGroup var1);
    }
}

