/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.ViewGroup;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.AssemblyItem;
import me.panpf.adapter.ClickListenerManager;
import me.panpf.adapter.Item;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.OnClickListener;
import me.panpf.adapter.OnLongClickListener;
import me.panpf.adapter.recycler.RecyclerItemWrapper;

public abstract class AssemblyItemFactory<DATA>
implements ItemFactory<DATA> {
    private int itemType;
    @Nullable
    private AssemblyAdapter adapter;
    private int spanSize = 1;
    private boolean fullSpanInStaggeredGrid;
    private boolean inRecycler;
    @Nullable
    private ClickListenerManager<DATA> clickListenerManager;

    @Override
    @NonNull
    public ItemFactory<DATA> getWrappedItemFactory() {
        return this;
    }

    @Override
    public int getItemType() {
        return this.itemType;
    }

    @Override
    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    @Override
    @Nullable
    public AssemblyAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void setAdapter(@NonNull AssemblyAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public int getSpanSize() {
        return this.spanSize;
    }

    @Override
    @NonNull
    public AssemblyItemFactory<DATA> setSpanSize(int spanSize) {
        if (spanSize > 0) {
            this.spanSize = spanSize;
        }
        return this;
    }

    @Override
    public boolean isInRecycler() {
        return this.inRecycler;
    }

    @Override
    public AssemblyItemFactory<DATA> setInRecycler(boolean inRecycler) {
        this.inRecycler = inRecycler;
        return this;
    }

    @Override
    public AssemblyItemFactory<DATA> setOnViewClickListener(@IdRes int viewId, @NonNull OnClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new ClickListenerManager();
        }
        this.clickListenerManager.add(viewId, onClickListener);
        return this;
    }

    @Override
    public AssemblyItemFactory<DATA> setOnItemClickListener(@NonNull OnClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new ClickListenerManager();
        }
        this.clickListenerManager.add(onClickListener);
        return this;
    }

    @Override
    public AssemblyItemFactory<DATA> setOnViewLongClickListener(@IdRes int viewId, @NonNull OnLongClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new ClickListenerManager();
        }
        this.clickListenerManager.add(viewId, onClickListener);
        return this;
    }

    @Override
    public AssemblyItemFactory<DATA> setOnItemLongClickListener(@NonNull OnLongClickListener<DATA> onClickListener) {
        if (this.clickListenerManager == null) {
            this.clickListenerManager = new ClickListenerManager();
        }
        this.clickListenerManager.add(onClickListener);
        return this;
    }

    @Override
    @NonNull
    public AssemblyItemFactory<DATA> fullSpan(@NonNull RecyclerView recyclerView) {
        this.setSpanSize(1);
        this.fullSpanInStaggeredGrid = false;
        if (recyclerView != null) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                this.setSpanSize(gridLayoutManager.getSpanCount());
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.fullSpanInStaggeredGrid = true;
            }
        }
        return this;
    }

    @Override
    @NonNull
    public Item<DATA> dispatchCreateItem(@NonNull ViewGroup parent) {
        ViewGroup.LayoutParams layoutParams;
        AssemblyItem<DATA> item = this.createAssemblyItem(parent);
        if (this.fullSpanInStaggeredGrid && (layoutParams = item.getItemView().getLayoutParams()) instanceof StaggeredGridLayoutManager.LayoutParams) {
            ((StaggeredGridLayoutManager.LayoutParams)layoutParams).setFullSpan(true);
            item.getItemView().setLayoutParams(layoutParams);
        }
        item.onInit(parent.getContext());
        Item<DATA> finalItem = this.inRecycler ? new RecyclerItemWrapper<DATA>(item) : item;
        this.registerListeners(finalItem);
        return finalItem;
    }

    private void registerListeners(Item<DATA> item) {
        if (this.clickListenerManager != null) {
            this.clickListenerManager.register(this, item, item.getItemView());
        }
    }

    @NonNull
    public abstract AssemblyItem<DATA> createAssemblyItem(@NonNull ViewGroup var1);
}

