/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;

public class FixedItemInfo {
    @NonNull
    private ItemFactory itemFactory;
    @NonNull
    private Object data;
    private boolean enabled;
    private int position;
    private boolean header;

    public FixedItemInfo(@NonNull ItemFactory itemFactory, @NonNull Object data, boolean header) {
        this.data = data;
        this.itemFactory = itemFactory;
        this.enabled = true;
        this.header = header;
    }

    @NonNull
    public Object getData() {
        return this.data;
    }

    public void setData(@NonNull Object data) {
        if (data == null) {
            throw new IllegalArgumentException("data is null");
        }
        this.data = data;
        AssemblyAdapter adapter = this.itemFactory.getAdapter();
        if (adapter != null && adapter.isNotifyOnChange()) {
            adapter.notifyDataSetChanged();
        }
    }

    @NonNull
    public ItemFactory getItemFactory() {
        return this.itemFactory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.enableChanged();
    }

    protected void enableChanged() {
        AssemblyAdapter adapter = this.itemFactory.getAdapter();
        if (adapter != null) {
            if (this.header) {
                adapter.headerEnabledChanged(this);
            } else {
                adapter.footerEnabledChanged(this);
            }
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isHeader() {
        return this.header;
    }
}

