/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.IdRes;
import android.support.annotation.NonNull;
import android.view.View;
import java.util.LinkedList;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ClickListenerHolder;
import me.panpf.adapter.Item;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.LongClickListenerHolder;
import me.panpf.adapter.OnClickListener;
import me.panpf.adapter.OnLongClickListener;
import me.panpf.adapter.R;

public class ClickListenerManager<DATA> {
    @NonNull
    private List<Object> holders = new LinkedList<Object>();

    public void add(@IdRes int viewId, @NonNull OnClickListener<DATA> onClickListener) {
        this.holders.add(new ClickListenerHolder<DATA>(viewId, onClickListener));
    }

    public void add(@NonNull OnClickListener<DATA> onClickListener) {
        this.holders.add(new ClickListenerHolder<DATA>(onClickListener));
    }

    public void add(@IdRes int viewId, @NonNull OnLongClickListener<DATA> onClickListener) {
        this.holders.add(new LongClickListenerHolder<DATA>(viewId, onClickListener));
    }

    public void add(@NonNull OnLongClickListener<DATA> onClickListener) {
        this.holders.add(new LongClickListenerHolder<DATA>(onClickListener));
    }

    public void register(final @NonNull ItemFactory<DATA> itemFactory, @NonNull Item<DATA> item, @NonNull View itemView) {
        for (Object holder : this.holders) {
            View targetView;
            int viewId;
            if (holder instanceof ClickListenerHolder) {
                final ClickListenerHolder clickListenerHolder = (ClickListenerHolder)holder;
                viewId = clickListenerHolder.getViewId();
                View view = targetView = viewId > 0 ? itemView.findViewById(viewId) : itemView;
                if (targetView == null) {
                    throw new IllegalArgumentException("Not found target view by id " + viewId);
                }
                targetView.setTag(R.id.aa_item_holder, item);
                targetView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Item item = (Item)targetView.getTag(R.id.aa_item_holder);
                        int position = item.getAdapterPosition();
                        AssemblyAdapter adapter = itemFactory.getAdapter();
                        int positionInPart = adapter != null ? adapter.getPositionInPart(position) : position;
                        clickListenerHolder.getListener().onViewClick(v, position, positionInPart, item.getData());
                    }
                });
                continue;
            }
            if (!(holder instanceof LongClickListenerHolder)) continue;
            final LongClickListenerHolder longClickListenerHolder = (LongClickListenerHolder)holder;
            viewId = longClickListenerHolder.getViewId();
            View view = targetView = viewId > 0 ? itemView.findViewById(viewId) : itemView;
            if (targetView == null) {
                throw new IllegalArgumentException("Not found target view by id " + viewId);
            }
            targetView.setTag(R.id.aa_item_holder, item);
            targetView.setOnLongClickListener(new View.OnLongClickListener(){

                public boolean onLongClick(View v) {
                    Item item = (Item)targetView.getTag(R.id.aa_item_holder);
                    int position = item.getAdapterPosition();
                    AssemblyAdapter adapter = itemFactory.getAdapter();
                    int positionInPart = adapter != null ? adapter.getPositionInPart(position) : position;
                    return longClickListenerHolder.getListener().onViewLongClick(v, position, positionInPart, item.getData());
                }
            });
        }
    }
}

