/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.panpf.adapter.pager.AssemblyFragmentItemFactory;
import me.panpf.adapter.pager.FixedFragmentItemInfo;

public class FragmentItemStorage {
    @NonNull
    private PagerAdapter adapter;
    @Nullable
    private List dataList;
    private boolean itemFactoryLocked;
    @Nullable
    private ArrayList<FixedFragmentItemInfo> headerItemList;
    @Nullable
    private ArrayList<FixedFragmentItemInfo> footerItemList;
    @Nullable
    private ArrayList<AssemblyFragmentItemFactory> itemFactoryList;

    public FragmentItemStorage(@NonNull PagerAdapter adapter) {
        this.adapter = adapter;
    }

    public FragmentItemStorage(@NonNull PagerAdapter adapter, @NonNull List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    public FragmentItemStorage(@NonNull PagerAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    public void addItemFactory(@NonNull AssemblyFragmentItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        if (this.itemFactoryList == null) {
            this.itemFactoryList = new ArrayList(2);
        }
        this.itemFactoryList.add(itemFactory);
    }

    @Nullable
    public List<AssemblyFragmentItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    public void addHeaderItem(@NonNull AssemblyFragmentItemFactory itemFactory, @Nullable Object data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        if (this.headerItemList == null) {
            this.headerItemList = new ArrayList(1);
        }
        this.headerItemList.add(new FixedFragmentItemInfo(itemFactory, data));
    }

    public void addHeaderItem(@NonNull AssemblyFragmentItemFactory itemFactory) {
        this.addHeaderItem(itemFactory, null);
    }

    @Nullable
    public List<FixedFragmentItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    public void addFooterItem(@NonNull AssemblyFragmentItemFactory itemFactory, @Nullable Object data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        if (this.footerItemList == null) {
            this.footerItemList = new ArrayList(1);
        }
        this.footerItemList.add(new FixedFragmentItemInfo(itemFactory, data));
    }

    public void addFooterItem(@NonNull AssemblyFragmentItemFactory itemFactory) {
        this.addFooterItem(itemFactory, null);
    }

    @Nullable
    public List<FixedFragmentItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }
}

