/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemStorage;

public class FixedItemInfo {
    @NonNull
    private ItemStorage itemStorage;
    @NonNull
    private ItemFactory itemFactory;
    @Nullable
    private Object data;
    private int position;
    private boolean header;
    private boolean enabled = true;

    public FixedItemInfo(@NonNull ItemStorage itemStorage, @NonNull ItemFactory itemFactory, @Nullable Object data, boolean header) {
        this.itemStorage = itemStorage;
        this.itemFactory = itemFactory;
        this.data = data;
        this.header = header;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void setData(@Nullable Object data) {
        this.data = data;
        AssemblyAdapter adapter = this.itemFactory.getAdapter();
        if (adapter != null && adapter.isNotifyOnChange()) {
            adapter.notifyDataSetChanged();
        }
    }

    @NonNull
    public ItemFactory getItemFactory() {
        return this.itemFactory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.enableChanged();
    }

    protected void enableChanged() {
        if (this.header) {
            this.itemStorage.headerEnabledChanged(this);
        } else {
            this.itemStorage.footerEnabledChanged(this);
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean isHeader() {
        return this.header;
    }
}

