/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.ViewGroup;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.AssemblyItem;
import me.panpf.adapter.ItemFactory;

public abstract class AssemblyItemFactory<ITEM extends AssemblyItem>
implements ItemFactory<ITEM> {
    private int itemType;
    private AssemblyAdapter adapter;
    private int spanSize = 1;
    private boolean fullSpanInStaggeredGrid;

    @Override
    @NonNull
    public ItemFactory<ITEM> getWrappedItemFactory() {
        return this;
    }

    @Override
    public int getItemType() {
        return this.itemType;
    }

    @Override
    public void setItemType(int itemType) {
        this.itemType = itemType;
    }

    @Override
    @Nullable
    public AssemblyAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    public void setAdapter(@NonNull AssemblyAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public int getSpanSize() {
        return this.spanSize;
    }

    @Override
    @NonNull
    public AssemblyItemFactory<ITEM> setSpanSize(int spanSize) {
        if (spanSize > 0) {
            this.spanSize = spanSize;
        }
        return this;
    }

    @Override
    @NonNull
    public AssemblyItemFactory<ITEM> fullSpan(@NonNull RecyclerView recyclerView) {
        this.setSpanSize(1);
        this.fullSpanInStaggeredGrid = false;
        if (recyclerView != null) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                this.setSpanSize(gridLayoutManager.getSpanCount());
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.fullSpanInStaggeredGrid = true;
            }
        }
        return this;
    }

    @Override
    @NonNull
    public ITEM dispatchCreateItem(@NonNull ViewGroup parent) {
        RecyclerView.LayoutParams recyclerLayoutParams;
        ViewGroup.LayoutParams layoutParams;
        ITEM item = this.createAssemblyItem(parent);
        if (this.fullSpanInStaggeredGrid && (layoutParams = ((AssemblyItem)item).getItemView().getLayoutParams()) != null && layoutParams instanceof RecyclerView.LayoutParams && (recyclerLayoutParams = (RecyclerView.LayoutParams)((AssemblyItem)item).getItemView().getLayoutParams()) instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams staggeredGridLayoutParams = (StaggeredGridLayoutManager.LayoutParams)recyclerLayoutParams;
            staggeredGridLayoutParams.setFullSpan(true);
            ((AssemblyItem)item).getItemView().setLayoutParams((ViewGroup.LayoutParams)recyclerLayoutParams);
        }
        ((AssemblyItem)item).onFindViews();
        ((AssemblyItem)item).onConfigViews(parent.getContext());
        return item;
    }

    @NonNull
    public abstract ITEM createAssemblyItem(@NonNull ViewGroup var1);
}

