/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.FixedItemInfo;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.more.LoadMoreFixedItemInfo;
import me.panpf.adapter.more.LoadMoreItemFactoryBridle;

public class ItemStorage {
    @NonNull
    private final Object headerItemListLock = new Object();
    @NonNull
    private final Object itemListLock = new Object();
    @NonNull
    private final Object itemFactoryListLock = new Object();
    @NonNull
    private final Object footerItemListLock = new Object();
    @NonNull
    private AssemblyAdapter adapter;
    private int itemTypeIndex = 0;
    private int headerItemPosition;
    private int footerItemPosition;
    private boolean itemFactoryLocked;
    @Nullable
    private ArrayList<FixedItemInfo> headerItemList;
    @Nullable
    private List dataList;
    @Nullable
    private ArrayList<FixedItemInfo> footerItemList;
    @Nullable
    private LoadMoreFixedItemInfo loadMoreFixedItemInfo;
    @Nullable
    private ArrayList<ItemFactory> itemFactoryList;
    @Nullable
    private SparseArray<Object> itemFactoryArray;
    private boolean notifyOnChange = true;

    public ItemStorage(@NonNull AssemblyAdapter adapter) {
        this.adapter = adapter;
    }

    public ItemStorage(@NonNull AssemblyAdapter adapter, @Nullable List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    public ItemStorage(@NonNull AssemblyAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    @NonNull
    public AssemblyAdapter getAdapter() {
        return this.adapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFactory(@NonNull ItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        itemFactory.setItemType(this.itemTypeIndex++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), (Object)itemFactory);
        Object object = this.itemFactoryListLock;
        synchronized (object) {
            if (this.itemFactoryList == null) {
                this.itemFactoryList = new ArrayList(5);
            }
            this.itemFactoryList.add(itemFactory);
        }
    }

    @Nullable
    public List<ItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FixedItemInfo addHeaderItem(@NonNull ItemFactory itemFactory, @Nullable Object data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        itemFactory.setItemType(this.itemTypeIndex++);
        FixedItemInfo fixedItemInfo = new FixedItemInfo(itemFactory, data, true);
        fixedItemInfo.setPosition(this.headerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), (Object)fixedItemInfo);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(1);
            }
            this.headerItemList.add(fixedItemInfo);
        }
        return fixedItemInfo;
    }

    @NonNull
    public FixedItemInfo addHeaderItem(@NonNull ItemFactory itemFactory) {
        return this.addHeaderItem(itemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void headerEnabledChanged(@NonNull FixedItemInfo fixedItemInfo) {
        if (fixedItemInfo == null || fixedItemInfo.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (fixedItemInfo.isEnabled()) {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList == null) {
                    this.headerItemList = new ArrayList(1);
                }
                this.headerItemList.add(fixedItemInfo);
                Collections.sort(this.headerItemList, new Comparator<FixedItemInfo>(){

                    @Override
                    public int compare(FixedItemInfo lhs, FixedItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList != null && this.headerItemList.remove(fixedItemInfo) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<FixedItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FixedItemInfo addFooterItem(@NonNull ItemFactory itemFactory, @Nullable Object data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        itemFactory.setItemType(this.itemTypeIndex++);
        FixedItemInfo fixedItemInfo = new FixedItemInfo(itemFactory, data, false);
        fixedItemInfo.setPosition(this.footerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), (Object)fixedItemInfo);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(1);
            }
            this.footerItemList.add(fixedItemInfo);
        }
        return fixedItemInfo;
    }

    @NonNull
    public FixedItemInfo addFooterItem(@NonNull ItemFactory itemFactory) {
        return this.addFooterItem(itemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void footerEnabledChanged(@NonNull FixedItemInfo fixedItemInfo) {
        if (fixedItemInfo == null || fixedItemInfo.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (fixedItemInfo.isEnabled()) {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList == null) {
                    this.footerItemList = new ArrayList(1);
                }
                this.footerItemList.add(fixedItemInfo);
                Collections.sort(this.footerItemList, new Comparator<FixedItemInfo>(){

                    @Override
                    public int compare(FixedItemInfo lhs, FixedItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList != null && this.footerItemList.remove(fixedItemInfo) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<FixedItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    @NonNull
    public LoadMoreFixedItemInfo setLoadMoreItem(@NonNull LoadMoreItemFactoryBridle itemFactory, @Nullable Object data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        if (this.loadMoreFixedItemInfo != null) {
            itemFactory.setItemType(this.loadMoreFixedItemInfo.getItemFactory().getItemType());
        } else {
            itemFactory.setItemType(this.itemTypeIndex++);
        }
        itemFactory.loadMoreFinished(false);
        LoadMoreFixedItemInfo loadMoreFixedItemInfo = new LoadMoreFixedItemInfo(itemFactory, data, false);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), (Object)loadMoreFixedItemInfo);
        this.loadMoreFixedItemInfo = loadMoreFixedItemInfo;
        return this.loadMoreFixedItemInfo;
    }

    @NonNull
    public LoadMoreFixedItemInfo setLoadMoreItem(@NonNull LoadMoreItemFactoryBridle itemFactory) {
        return this.setLoadMoreItem(itemFactory, null);
    }

    @Nullable
    public LoadMoreFixedItemInfo getLoadMoreFixedItemInfo() {
        return this.loadMoreFixedItemInfo;
    }

    public void setDisableLoadMore(boolean disableLoadMore) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.setEnabled(!disableLoadMore);
        }
    }

    public boolean hasLoadMoreFooter() {
        return this.loadMoreFixedItemInfo != null && this.loadMoreFixedItemInfo.isEnabled();
    }

    public void loadMoreFinished(boolean loadMoreEnd) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFinished(loadMoreEnd);
        }
    }

    public void loadMoreFailed() {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFailed();
        }
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(@Nullable List dataList) {
        Object object = this.itemListLock;
        synchronized (object) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nullable Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@Nullable Object object, int index) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@NonNull Comparator comparator) {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    public int getViewTypeCount() {
        this.itemFactoryLocked = true;
        return this.itemTypeIndex > 0 ? this.itemTypeIndex : 1;
    }

    @Nullable
    public Object getItemFactoryByViewType(int viewType) {
        return this.itemFactoryArray != null ? this.itemFactoryArray.get(viewType) : null;
    }
}

