/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.FixedPagerItemInfo;

public class PagerItemStorage {
    @NonNull
    private final Object itemListLock = new Object();
    @NonNull
    private final Object headerItemListLock = new Object();
    @NonNull
    private final Object itemFactoryListLock = new Object();
    @NonNull
    private final Object footerItemListLock = new Object();
    @NonNull
    private AssemblyPagerAdapter adapter;
    private int headerItemPosition;
    private int footerItemPosition;
    private boolean itemFactoryLocked;
    @Nullable
    private List dataList;
    @Nullable
    private ArrayList<FixedPagerItemInfo> headerItemList;
    @Nullable
    private ArrayList<FixedPagerItemInfo> footerItemList;
    @Nullable
    private ArrayList<AssemblyPagerItemFactory> itemFactoryList;
    private boolean notifyOnChange = true;

    public PagerItemStorage(@NonNull AssemblyPagerAdapter adapter) {
        this.adapter = adapter;
    }

    public PagerItemStorage(@NonNull AssemblyPagerAdapter adapter, @Nullable List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    public PagerItemStorage(@NonNull AssemblyPagerAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFactory(@NonNull AssemblyPagerItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        Object object = this.itemFactoryListLock;
        synchronized (object) {
            if (this.itemFactoryList == null) {
                this.itemFactoryList = new ArrayList(2);
            }
            this.itemFactoryList.add(itemFactory);
        }
    }

    @Nullable
    public List<AssemblyPagerItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FixedPagerItemInfo addHeaderItem(@NonNull AssemblyPagerItemFactory itemFactory, @Nullable Object data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        FixedPagerItemInfo headerItemInfo = new FixedPagerItemInfo(itemFactory, data, true);
        headerItemInfo.setPosition(this.headerItemPosition++);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(1);
            }
            this.headerItemList.add(headerItemInfo);
        }
        return headerItemInfo;
    }

    @NonNull
    public FixedPagerItemInfo addHeaderItem(@NonNull AssemblyPagerItemFactory itemFactory) {
        return this.addHeaderItem(itemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headerEnabledChanged(@NonNull FixedPagerItemInfo headerItemInfo) {
        if (headerItemInfo.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (headerItemInfo.isEnabled()) {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList == null) {
                    this.headerItemList = new ArrayList(1);
                }
                this.headerItemList.add(headerItemInfo);
                Collections.sort(this.headerItemList, new Comparator<FixedPagerItemInfo>(){

                    @Override
                    public int compare(FixedPagerItemInfo lhs, FixedPagerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList != null && this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<FixedPagerItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FixedPagerItemInfo addFooterItem(@NonNull AssemblyPagerItemFactory itemFactory, @Nullable Object data) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        FixedPagerItemInfo footerItemInfo = new FixedPagerItemInfo(itemFactory, data, false);
        footerItemInfo.setPosition(this.footerItemPosition++);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(1);
            }
            this.footerItemList.add(footerItemInfo);
        }
        return footerItemInfo;
    }

    @NonNull
    public FixedPagerItemInfo addFooterItem(@NonNull AssemblyPagerItemFactory itemFactory) {
        return this.addFooterItem(itemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void footerEnabledChanged(@NonNull FixedPagerItemInfo footerItemInfo) {
        if (footerItemInfo.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (footerItemInfo.isEnabled()) {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList == null) {
                    this.footerItemList = new ArrayList(1);
                }
                this.footerItemList.add(footerItemInfo);
                Collections.sort(this.footerItemList, new Comparator<FixedPagerItemInfo>(){

                    @Override
                    public int compare(FixedPagerItemInfo lhs, FixedPagerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList != null && this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<FixedPagerItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(@Nullable List dataList) {
        Object object = this.itemListLock;
        synchronized (object) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nullable Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@NonNull Object object, int index) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@NonNull Comparator comparator) {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }
}

