/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.expandable;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import java.util.List;
import me.panpf.adapter.AssemblyExpandableAdapter;
import me.panpf.adapter.ItemActor;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.expandable.AssemblyGroup;

public class ExpandableItemActor
extends ItemActor {
    @NonNull
    private AssemblyExpandableAdapter adapter;

    public ExpandableItemActor(@NonNull AssemblyExpandableAdapter adapter) {
        super(adapter);
        this.adapter = adapter;
    }

    public int getChildrenCount(int groupPosition) {
        Object groupObject = this.getItem(groupPosition);
        if (groupObject != null && groupObject instanceof AssemblyGroup) {
            return ((AssemblyGroup)groupObject).getChildCount();
        }
        return 0;
    }

    @Nullable
    public Object getChild(int groupPosition, int childPosition) {
        Object groupDataObject = this.getItem(groupPosition);
        if (groupDataObject == null) {
            return null;
        }
        if (!(groupDataObject instanceof AssemblyGroup)) {
            throw new IllegalArgumentException(String.format("group object must implements AssemblyGroup interface. groupPosition=%d, groupDataObject=%s", groupPosition, groupDataObject.getClass().getName()));
        }
        return ((AssemblyGroup)groupDataObject).getChild(childPosition);
    }

    public int getChildType(int groupPosition, int childPosition) {
        if (this.adapter.getChildItemFactoryCount() <= 0) {
            throw new IllegalStateException("You need to configure ItemFactory use addChildItemFactory method");
        }
        Object childDataObject = this.getChild(groupPosition, childPosition);
        List<ItemFactory> childItemFactoryList = this.adapter.getChildItemFactoryList();
        if (childItemFactoryList != null) {
            int size = childItemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                ItemFactory childItemFactory = childItemFactoryList.get(w);
                if (!childItemFactory.isTarget(childDataObject)) continue;
                return childItemFactory.getItemType();
            }
        }
        throw new IllegalStateException(String.format("Didn't find suitable ItemFactory. groupPosition=%d, childPosition=%d, childDataObject=%s", groupPosition, childPosition, childDataObject != null ? childDataObject.getClass().getName() : "null"));
    }
}

