/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.content.Context;
import android.support.annotation.LayoutRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import me.panpf.adapter.AssemblyItem;
import me.panpf.adapter.AssemblyItemFactory;

public class ViewItemFactory
extends AssemblyItemFactory<ViewItem> {
    @NonNull
    private ViewFactory viewFactory;
    @Nullable
    private Class<?> dataClazz;
    @Nullable
    private OnClickViewListener listener;

    public ViewItemFactory(@NonNull ViewFactory viewFactory, @Nullable Class<?> dataClazz, @Nullable OnClickViewListener listener) {
        this.viewFactory = viewFactory;
        this.dataClazz = dataClazz;
        this.listener = listener;
    }

    public ViewItemFactory(@NonNull ViewFactory viewFactory, @Nullable Class<?> dataClazz) {
        this(viewFactory, dataClazz, null);
    }

    public ViewItemFactory(@NonNull ViewFactory viewFactory, @Nullable OnClickViewListener listener) {
        this(viewFactory, null, listener);
    }

    public ViewItemFactory(@NonNull ViewFactory viewFactory) {
        this(viewFactory, null, null);
    }

    public ViewItemFactory(final @LayoutRes int layoutResId, @Nullable Class<?> dataClazz, @Nullable OnClickViewListener listener) {
        this(new ViewFactory(){

            @Override
            @NonNull
            public View createItemView(@NonNull ViewGroup parent) {
                return LayoutInflater.from((Context)parent.getContext()).inflate(layoutResId, parent, false);
            }
        }, dataClazz, listener);
    }

    public ViewItemFactory(@LayoutRes int layoutResId, @Nullable Class<?> dataClazz) {
        this(layoutResId, dataClazz, null);
    }

    public ViewItemFactory(@LayoutRes int layoutResId, @Nullable OnClickViewListener listener) {
        this(layoutResId, null, listener);
    }

    public ViewItemFactory(@LayoutRes int layoutResId) {
        this(layoutResId, null, null);
    }

    public ViewItemFactory(final @NonNull View view, @Nullable Class<?> dataClazz, @Nullable OnClickViewListener listener) {
        this(new ViewFactory(){

            @Override
            @NonNull
            public View createItemView(@NonNull ViewGroup parent) {
                return view;
            }
        }, dataClazz, listener);
    }

    public ViewItemFactory(@NonNull View view, @Nullable Class<?> dataClazz) {
        this(view, dataClazz, null);
    }

    public ViewItemFactory(@NonNull View view, @Nullable OnClickViewListener listener) {
        this(view, null, listener);
    }

    public ViewItemFactory(@NonNull View view) {
        this(view, null, null);
    }

    @Override
    public boolean isTarget(@NonNull Object data) {
        return this.dataClazz == null || this.dataClazz.isInstance(data);
    }

    @Override
    @NonNull
    public ViewItem createAssemblyItem(@NonNull ViewGroup parent) {
        return new ViewItem(this.viewFactory.createItemView(parent));
    }

    public class ViewItem
    extends AssemblyItem<Object> {
        ViewItem(View itemView) {
            super(itemView);
        }

        @Override
        protected void onConfigViews(@NonNull Context context) {
            if (ViewItemFactory.this.listener != null) {
                this.getItemView().setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ViewItemFactory.this.listener.onClickView(ViewItem.this.getAdapterPosition(), ViewItem.this.getData());
                    }
                });
            }
        }

        @Override
        protected void onSetData(int position, @NonNull Object o) {
        }
    }

    public static interface OnClickViewListener {
        public void onClickView(int var1, @Nullable Object var2);
    }

    public static interface ViewFactory {
        @NonNull
        public View createItemView(@NonNull ViewGroup var1);
    }
}

