/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;
import me.panpf.adapter.pager.FixedPagerItemInfo;

public class PagerItemStorage {
    @NonNull
    private final Object itemListLock = new Object();
    @NonNull
    private final Object headerItemListLock = new Object();
    @NonNull
    private final Object itemFactoryListLock = new Object();
    @NonNull
    private final Object footerItemListLock = new Object();
    @NonNull
    private AssemblyPagerAdapter adapter;
    private int headerItemPosition;
    private int footerItemPosition;
    private boolean itemFactoryLocked;
    @Nullable
    private List dataList;
    @Nullable
    private ArrayList<FixedPagerItemInfo> headerItemList;
    @Nullable
    private ArrayList<FixedPagerItemInfo> footerItemList;
    @Nullable
    private ArrayList<AssemblyPagerItemFactory> itemFactoryList;
    private boolean notifyOnChange = true;

    public PagerItemStorage(@NonNull AssemblyPagerAdapter adapter) {
        this.adapter = adapter;
    }

    public PagerItemStorage(@NonNull AssemblyPagerAdapter adapter, @Nullable List dataList) {
        this.adapter = adapter;
        this.dataList = dataList;
    }

    public PagerItemStorage(@NonNull AssemblyPagerAdapter adapter, @Nullable Object[] dataArray) {
        this.adapter = adapter;
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFactory(@NonNull AssemblyPagerItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        itemFactory.setAdapter(this.adapter);
        Object object = this.itemFactoryListLock;
        synchronized (object) {
            if (this.itemFactoryList == null) {
                this.itemFactoryList = new ArrayList(2);
            }
            this.itemFactoryList.add(itemFactory);
        }
    }

    @Nullable
    public List<AssemblyPagerItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FixedPagerItemInfo addHeaderItem(@NonNull AssemblyPagerItemFactory headerFactory, @Nullable Object data) {
        if (headerFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        headerFactory.setAdapter(this.adapter);
        FixedPagerItemInfo headerItemInfo = new FixedPagerItemInfo(headerFactory, data, true);
        headerItemInfo.setPosition(this.headerItemPosition++);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(1);
            }
            this.headerItemList.add(headerItemInfo);
        }
        return headerItemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headerEnabledChanged(@NonNull FixedPagerItemInfo headerItemInfo) {
        if (headerItemInfo.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (headerItemInfo.isEnabled()) {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList == null) {
                    this.headerItemList = new ArrayList(1);
                }
                this.headerItemList.add(headerItemInfo);
                Collections.sort(this.headerItemList, new Comparator<FixedPagerItemInfo>(){

                    @Override
                    public int compare(FixedPagerItemInfo lhs, FixedPagerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList != null && this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<FixedPagerItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    @Nullable
    public Object getHeaderData(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public FixedPagerItemInfo addFooterItem(@NonNull AssemblyPagerItemFactory footerFactory, @Nullable Object data) {
        if (footerFactory == null || this.itemFactoryLocked) {
            throw new IllegalArgumentException("itemFactory is null or item factory list locked");
        }
        footerFactory.setAdapter(this.adapter);
        FixedPagerItemInfo footerItemInfo = new FixedPagerItemInfo(footerFactory, data, false);
        footerItemInfo.setPosition(this.footerItemPosition++);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(1);
            }
            this.footerItemList.add(footerItemInfo);
        }
        return footerItemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void footerEnabledChanged(@NonNull FixedPagerItemInfo footerItemInfo) {
        if (footerItemInfo.getItemFactory().getAdapter() != this.adapter) {
            return;
        }
        if (footerItemInfo.isEnabled()) {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList == null) {
                    this.footerItemList = new ArrayList(1);
                }
                this.footerItemList.add(footerItemInfo);
                Collections.sort(this.footerItemList, new Comparator<FixedPagerItemInfo>(){

                    @Override
                    public int compare(FixedPagerItemInfo lhs, FixedPagerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.adapter.notifyDataSetChanged();
            }
        } else {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList != null && this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                    this.adapter.notifyDataSetChanged();
                }
            }
        }
    }

    @Nullable
    public List<FixedPagerItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    @Nullable
    public Object getFooterData(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    @Nullable
    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(@Nullable List dataList) {
        Object object = this.itemListLock;
        synchronized (object) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(@Nullable Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(@NonNull Object object, int index) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@NonNull Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(@NonNull Comparator comparator) {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.adapter.notifyDataSetChanged();
        }
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    @Nullable
    public Object getData(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    public int getItemCount() {
        this.itemFactoryLocked = true;
        return this.getHeaderItemCount() + this.getDataCount() + this.getFooterItemCount();
    }

    @NonNull
    public View getItem(@NonNull ViewGroup container, int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (this.headerItemList != null && position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            FixedPagerItemInfo fixedItemInfo = this.headerItemList.get(positionInHeaderList);
            View itemView = fixedItemInfo.getItemFactory().dispatchCreateView(container.getContext(), container, position, fixedItemInfo.getData());
            container.addView(itemView);
            return itemView;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (this.itemFactoryList != null && position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getData(positionInDataList);
            int size = this.itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyPagerItemFactory itemFactory = this.itemFactoryList.get(w);
                if (!itemFactory.isTarget(dataObject)) continue;
                View itemView = itemFactory.dispatchCreateView(container.getContext(), container, position, dataObject);
                container.addView(itemView);
                return itemView;
            }
            throw new IllegalStateException(String.format("Didn't find suitable AssemblyPagerItemFactory. position=%d, dataObject=%s", position, dataObject != null ? dataObject.getClass().getName() : "null"));
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (this.footerItemList != null && position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            FixedPagerItemInfo fixedItemInfo = this.footerItemList.get(positionInFooterList);
            View itemView = fixedItemInfo.getItemFactory().dispatchCreateView(container.getContext(), container, position, fixedItemInfo.getData());
            container.addView(itemView);
            return itemView;
        }
        throw new IllegalArgumentException("Illegal position: " + position);
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }
}

