/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.pager;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import me.panpf.adapter.pager.AssemblyPagerAdapter;
import me.panpf.adapter.pager.AssemblyPagerItemFactory;

public class FixedPagerItemInfo {
    @NonNull
    private AssemblyPagerItemFactory itemFactory;
    @Nullable
    private Object data;
    private boolean enabled;
    private int position;
    private boolean header;

    public FixedPagerItemInfo(@NonNull AssemblyPagerItemFactory itemFactory, @Nullable Object data, boolean header) {
        this.data = data;
        this.itemFactory = itemFactory;
        this.enabled = true;
        this.header = header;
    }

    @Nullable
    public Object getData() {
        return this.data;
    }

    public void setData(@Nullable Object data) {
        this.data = data;
        AssemblyPagerAdapter adapter = this.itemFactory.getAdapter();
        if (adapter != null && adapter.isNotifyOnChange()) {
            adapter.notifyDataSetChanged();
        }
    }

    @NonNull
    public AssemblyPagerItemFactory getItemFactory() {
        return this.itemFactory;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        this.enableChanged();
    }

    protected void enableChanged() {
        if (this.header) {
            AssemblyPagerAdapter adapter = this.itemFactory.getAdapter();
            if (adapter != null) {
                adapter.headerEnabledChanged(this);
            }
        } else {
            AssemblyPagerAdapter adapter = this.itemFactory.getAdapter();
            if (adapter != null) {
                adapter.footerEnabledChanged(this);
            }
        }
    }

    public int getPosition() {
        return this.position;
    }

    void setPosition(int position) {
        this.position = position;
    }

    public boolean isHeader() {
        return this.header;
    }
}

