/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter.expandable;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.List;
import me.panpf.adapter.AssemblyAdapter;
import me.panpf.adapter.ItemFactory;
import me.panpf.adapter.ItemStorage;
import me.panpf.adapter.expandable.AssemblyGroup;

public class ExpandableItemStorage
extends ItemStorage {
    @NonNull
    private final Object childItemFactoryListLock = new Object();
    private int childTypeIndex = 0;
    private boolean childItemFactoryLocked;
    @Nullable
    private ArrayList<ItemFactory> childItemFactoryList;
    @Nullable
    private SparseArray<Object> childItemFactoryArray;

    public ExpandableItemStorage(@NonNull AssemblyAdapter adapter) {
        super(adapter);
    }

    public ExpandableItemStorage(@NonNull AssemblyAdapter adapter, @Nullable List dataList) {
        super(adapter, dataList);
    }

    public ExpandableItemStorage(@NonNull AssemblyAdapter adapter, @Nullable Object[] dataArray) {
        super(adapter, dataArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildItemFactory(@NonNull ItemFactory childItemFactory) {
        if (childItemFactory == null || this.childItemFactoryLocked) {
            throw new IllegalStateException("childItemFactory is null or item factory list locked");
        }
        childItemFactory.setAdapter(this.getAdapter());
        childItemFactory.setItemType(this.childTypeIndex++);
        if (this.childItemFactoryArray == null) {
            this.childItemFactoryArray = new SparseArray();
        }
        this.childItemFactoryArray.put(childItemFactory.getItemType(), (Object)childItemFactory);
        Object object = this.childItemFactoryListLock;
        synchronized (object) {
            if (this.childItemFactoryList == null) {
                this.childItemFactoryList = new ArrayList(5);
            }
            this.childItemFactoryList.add(childItemFactory);
        }
    }

    @Nullable
    public List<ItemFactory> getChildItemFactoryList() {
        return this.childItemFactoryList;
    }

    public int getChildItemFactoryCount() {
        return this.childItemFactoryList != null ? this.childItemFactoryList.size() : 0;
    }

    public int getChildrenCount(int groupPosition) {
        Object groupObject = this.getItem(groupPosition);
        if (groupObject != null && groupObject instanceof AssemblyGroup) {
            return ((AssemblyGroup)groupObject).getChildCount();
        }
        return 0;
    }

    @Nullable
    public Object getChild(int groupPosition, int childPosition) {
        Object groupDataObject = this.getItem(groupPosition);
        if (groupDataObject == null) {
            return null;
        }
        if (!(groupDataObject instanceof AssemblyGroup)) {
            throw new IllegalArgumentException(String.format("group object must implements AssemblyGroup interface. groupPosition=%d, groupDataObject=%s", groupPosition, groupDataObject.getClass().getName()));
        }
        return ((AssemblyGroup)groupDataObject).getChild(childPosition);
    }

    public int getChildTypeCount() {
        this.childItemFactoryLocked = true;
        return this.childTypeIndex > 0 ? this.childTypeIndex : 1;
    }

    public int getChildType(int groupPosition, int childPosition) {
        if (this.getChildItemFactoryCount() <= 0) {
            throw new IllegalStateException("You need to configure ItemFactory use addChildItemFactory method");
        }
        this.childItemFactoryLocked = true;
        Object childDataObject = this.getChild(groupPosition, childPosition);
        if (this.childItemFactoryList != null) {
            int size = this.childItemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                ItemFactory childItemFactory = this.childItemFactoryList.get(w);
                if (!childItemFactory.isTarget(childDataObject)) continue;
                return childItemFactory.getItemType();
            }
        }
        throw new IllegalStateException(String.format("Didn't find suitable ItemFactory. groupPosition=%d, childPosition=%d, childDataObject=%s", groupPosition, childPosition, childDataObject != null ? childDataObject.getClass().getName() : "null"));
    }

    @Nullable
    public Object getChildItemFactoryByViewType(int viewType) {
        return this.childItemFactoryArray != null ? this.childItemFactoryArray.get(viewType) : null;
    }
}

