/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.ViewGroup;
import me.panpf.adapter.AssemblyRecyclerAdapter;
import me.panpf.adapter.AssemblyRecyclerItem;

public abstract class AssemblyRecyclerItemFactory<ITEM extends AssemblyRecyclerItem> {
    private int itemType;
    private int spanSize = 1;
    private AssemblyRecyclerAdapter adapter;
    private boolean fullSpanInStaggeredGrid;

    public int getItemType() {
        return this.itemType;
    }

    void setItemType(int itemType) {
        this.itemType = itemType;
    }

    public AssemblyRecyclerAdapter getAdapter() {
        return this.adapter;
    }

    void setAdapter(AssemblyRecyclerAdapter adapter) {
        this.adapter = adapter;
    }

    public int getSpanSize() {
        return this.spanSize;
    }

    public AssemblyRecyclerItemFactory<ITEM> setSpanSize(int spanSize) {
        if (spanSize > 0) {
            this.spanSize = spanSize;
        }
        return this;
    }

    public AssemblyRecyclerItemFactory<ITEM> fullSpan(RecyclerView recyclerView) {
        this.setSpanSize(1);
        this.fullSpanInStaggeredGrid = false;
        if (recyclerView != null) {
            RecyclerView.LayoutManager layoutManager = recyclerView.getLayoutManager();
            if (layoutManager instanceof GridLayoutManager) {
                GridLayoutManager gridLayoutManager = (GridLayoutManager)layoutManager;
                this.setSpanSize(gridLayoutManager.getSpanCount());
            } else if (layoutManager instanceof StaggeredGridLayoutManager) {
                this.fullSpanInStaggeredGrid = true;
            }
        }
        return this;
    }

    protected ITEM dispatchCreateAssemblyItem(ViewGroup parent) {
        RecyclerView.LayoutParams layoutParams;
        ITEM item = this.createAssemblyItem(parent);
        if (this.fullSpanInStaggeredGrid && (layoutParams = (RecyclerView.LayoutParams)((AssemblyRecyclerItem)((Object)item)).getItemView().getLayoutParams()) instanceof StaggeredGridLayoutManager.LayoutParams) {
            StaggeredGridLayoutManager.LayoutParams staggeredGridLayoutParams = (StaggeredGridLayoutManager.LayoutParams)layoutParams;
            staggeredGridLayoutParams.setFullSpan(true);
            ((AssemblyRecyclerItem)((Object)item)).getItemView().setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        }
        ((AssemblyRecyclerItem)((Object)item)).onFindViews();
        ((AssemblyRecyclerItem)((Object)item)).onConfigViews(parent.getContext());
        return item;
    }

    public abstract boolean isTarget(Object var1);

    public abstract ITEM createAssemblyItem(ViewGroup var1);
}

