/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.Nullable;
import android.support.v7.widget.RecyclerView;
import android.util.Log;
import android.util.SparseArray;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyLoadMoreRecyclerItemFactory;
import me.panpf.adapter.AssemblyRecyclerItem;
import me.panpf.adapter.AssemblyRecyclerItemFactory;
import me.panpf.adapter.FixedRecyclerItemInfo;
import me.panpf.adapter.LoadMoreFixedRecyclerItemInfo;

public class AssemblyRecyclerAdapter
extends RecyclerView.Adapter {
    private static final String TAG = "AssemblyRecyclerAdapter";
    private final Object itemListLock = new Object();
    private final Object headerItemListLock = new Object();
    private final Object itemFactoryListLock = new Object();
    private final Object footerItemListLock = new Object();
    private int itemTypeIndex = 0;
    private int headerItemPosition;
    private int footerItemPosition;
    private boolean itemFactoryLocked;
    private List dataList;
    private ArrayList<FixedRecyclerItemInfo> headerItemList;
    private ArrayList<FixedRecyclerItemInfo> footerItemList;
    private ArrayList<AssemblyRecyclerItemFactory> itemFactoryList;
    private SparseArray<Object> itemFactoryArray;
    private LoadMoreFixedRecyclerItemInfo loadMoreFixedItemInfo;
    private boolean notifyOnChange = true;

    public AssemblyRecyclerAdapter(List dataList) {
        this.dataList = dataList;
    }

    public AssemblyRecyclerAdapter(Object[] dataArray) {
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedRecyclerItemInfo addHeaderItem(AssemblyRecyclerItemFactory headerFactory, Object data) {
        if (headerFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"headerFactory is nll or item factory locked");
            return null;
        }
        headerFactory.setAdapter(this);
        headerFactory.setItemType(this.itemTypeIndex++);
        FixedRecyclerItemInfo headerItemInfo = new FixedRecyclerItemInfo(headerFactory, data, true);
        headerItemInfo.setPosition(this.headerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(headerFactory.getItemType(), (Object)headerItemInfo);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(2);
            }
            this.headerItemList.add(headerItemInfo);
        }
        return headerItemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFactory(AssemblyRecyclerItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"itemFactory is nll or item factory locked");
            return;
        }
        itemFactory.setAdapter(this);
        itemFactory.setItemType(this.itemTypeIndex++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(itemFactory.getItemType(), (Object)itemFactory);
        Object object = this.itemFactoryListLock;
        synchronized (object) {
            if (this.itemFactoryList == null) {
                this.itemFactoryList = new ArrayList(5);
            }
            this.itemFactoryList.add(itemFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedRecyclerItemInfo addFooterItem(AssemblyRecyclerItemFactory footerFactory, Object data) {
        if (footerFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"footerFactory is nll or item factory locked");
            return null;
        }
        footerFactory.setAdapter(this);
        footerFactory.setItemType(this.itemTypeIndex++);
        FixedRecyclerItemInfo footerItemInfo = new FixedRecyclerItemInfo(footerFactory, data, false);
        footerItemInfo.setPosition(this.footerItemPosition++);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(footerFactory.getItemType(), (Object)footerItemInfo);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(2);
            }
            this.footerItemList.add(footerItemInfo);
        }
        return footerItemInfo;
    }

    public LoadMoreFixedRecyclerItemInfo setLoadMoreItem(AssemblyLoadMoreRecyclerItemFactory loadMoreItemFactory, Object data) {
        if (loadMoreItemFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"loadMoreItemFactory is null or item factory locked");
            return null;
        }
        loadMoreItemFactory.setAdapter(this);
        if (this.loadMoreFixedItemInfo != null) {
            loadMoreItemFactory.setItemType(this.loadMoreFixedItemInfo.getItemFactory().getItemType());
        } else {
            loadMoreItemFactory.setItemType(this.itemTypeIndex++);
        }
        loadMoreItemFactory.loadMoreFinished(false);
        LoadMoreFixedRecyclerItemInfo loadMoreFixedItemInfo = new LoadMoreFixedRecyclerItemInfo(loadMoreItemFactory, data, false);
        if (this.itemFactoryArray == null) {
            this.itemFactoryArray = new SparseArray();
        }
        this.itemFactoryArray.put(loadMoreItemFactory.getItemType(), (Object)loadMoreFixedItemInfo);
        this.loadMoreFixedItemInfo = loadMoreFixedItemInfo;
        return this.loadMoreFixedItemInfo;
    }

    public LoadMoreFixedRecyclerItemInfo setLoadMoreItem(AssemblyLoadMoreRecyclerItemFactory loadMoreItemFactory) {
        return this.setLoadMoreItem(loadMoreItemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Object object, int index) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator comparator) {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public void setDisableLoadMore(boolean disableLoadMore) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.setEnabled(!disableLoadMore);
        }
    }

    @Deprecated
    public void setLoadMoreEnd(boolean loadMoreEnd) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFinished(loadMoreEnd);
        }
    }

    public void loadMoreFinished(boolean loadMoreEnd) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFinished(loadMoreEnd);
        }
    }

    public void loadMoreFailed() {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headerEnabledChanged(FixedRecyclerItemInfo headerItemInfo) {
        if (headerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        if (headerItemInfo.isEnabled()) {
            Object object = this.headerItemListLock;
            synchronized (object) {
                this.headerItemList.add(headerItemInfo);
                Collections.sort(this.headerItemList, new Comparator<FixedRecyclerItemInfo>(){

                    @Override
                    public int compare(FixedRecyclerItemInfo lhs, FixedRecyclerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        } else {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void footerEnabledChanged(FixedRecyclerItemInfo footerItemInfo) {
        if (footerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        if (footerItemInfo.isEnabled()) {
            Object object = this.footerItemListLock;
            synchronized (object) {
                this.footerItemList.add(footerItemInfo);
                Collections.sort(this.footerItemList, new Comparator<FixedRecyclerItemInfo>(){

                    @Override
                    public int compare(FixedRecyclerItemInfo lhs, FixedRecyclerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        } else {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeHeaderItem(FixedRecyclerItemInfo headerItemInfo) {
        if (headerItemInfo == null) {
            return;
        }
        if (headerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList != null && this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeFooterItem(FixedRecyclerItemInfo footerItemInfo) {
        if (footerItemInfo == null) {
            return;
        }
        if (footerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList != null && this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    public List<FixedRecyclerItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public List<AssemblyRecyclerItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public List<FixedRecyclerItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(List dataList) {
        Object object = this.itemListLock;
        synchronized (object) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    public boolean hasLoadMoreFooter() {
        return this.loadMoreFixedItemInfo != null && this.loadMoreFixedItemInfo.isEnabled();
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        if (dataCount > 0 && this.hasLoadMoreFooter() && position == this.getItemCount() - 1) {
            return 0;
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }

    public int getSpanSize(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemList.get(positionInHeaderList).getItemFactory().getSpanSize();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getDataItem(positionInDataList);
            int size = this.itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyRecyclerItemFactory itemFactory = this.itemFactoryList.get(w);
                if (!itemFactory.isTarget(dataObject)) continue;
                return itemFactory.getSpanSize();
            }
            throw new IllegalStateException("Didn't find suitable AssemblyItemFactory. positionInDataList=" + positionInDataList + ", dataObject=" + (dataObject != null ? dataObject.getClass().getName() : "null"));
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemList.get(positionInFooterList).getItemFactory().getSpanSize();
        }
        if (dataCount > 0 && this.hasLoadMoreFooter() && position == this.getItemCount() - 1) {
            return this.loadMoreFixedItemInfo.getItemFactory().getSpanSize();
        }
        return 1;
    }

    public int getItemCount() {
        int headerItemCount = this.getHeaderItemCount();
        int dataCount = this.getDataCount();
        int footerItemCount = this.getFooterItemCount();
        if (dataCount > 0) {
            return headerItemCount + dataCount + footerItemCount + (this.hasLoadMoreFooter() ? 1 : 0);
        }
        return headerItemCount + footerItemCount;
    }

    public Object getItem(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.getHeaderItem(positionInHeaderList);
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            return this.getDataItem(positionInDataList);
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.getFooterItem(positionInFooterList);
        }
        if (dataCount > 0 && this.hasLoadMoreFooter() && position == this.getItemCount() - 1) {
            return this.loadMoreFixedItemInfo.getData();
        }
        return null;
    }

    @Nullable
    public Object getHeaderItem(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    @Nullable
    public Object getDataItem(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    @Nullable
    public Object getFooterItem(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    public long getItemId(int position) {
        return position;
    }

    public int getItemViewType(int position) {
        this.itemFactoryLocked = true;
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            return this.headerItemList.get(positionInHeaderList).getItemFactory().getItemType();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getDataItem(positionInDataList);
            int size = this.itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyRecyclerItemFactory itemFactory = this.itemFactoryList.get(w);
                if (!itemFactory.isTarget(dataObject)) continue;
                return itemFactory.getItemType();
            }
            throw new IllegalStateException("Didn't find suitable AssemblyItemFactory. positionInDataList=" + positionInDataList + ", dataObject=" + (dataObject != null ? dataObject.getClass().getName() : "null"));
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            return this.footerItemList.get(positionInFooterList).getItemFactory().getItemType();
        }
        if (dataCount > 0 && this.hasLoadMoreFooter() && position == this.getItemCount() - 1) {
            return this.loadMoreFixedItemInfo.getItemFactory().getItemType();
        }
        throw new IllegalStateException("not found match viewType, position: " + position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        Object item = this.itemFactoryArray.get(viewType);
        if (item instanceof AssemblyRecyclerItemFactory) {
            AssemblyRecyclerItemFactory itemFactory = (AssemblyRecyclerItemFactory)item;
            return itemFactory.dispatchCreateAssemblyItem(parent);
        }
        if (item instanceof FixedRecyclerItemInfo) {
            FixedRecyclerItemInfo fixedItemInfo = (FixedRecyclerItemInfo)item;
            return fixedItemInfo.getItemFactory().dispatchCreateAssemblyItem(parent);
        }
        throw new IllegalStateException("unknown viewType: " + viewType + ", itemFactory: " + (item != null ? item.getClass().getName() : "null"));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof AssemblyRecyclerItem) {
            ((AssemblyRecyclerItem)viewHolder).setData(position, this.getItem(position));
        }
    }
}

