/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.adapter.AssemblyPagerItemFactory;
import me.panpf.adapter.FixedPagerItemInfo;

public class AssemblyPagerAdapter
extends PagerAdapter {
    private static final String TAG = "AssemblyPagerAdapter";
    private final Object itemListLock = new Object();
    private final Object headerItemListLock = new Object();
    private final Object itemFactoryListLock = new Object();
    private final Object footerItemListLock = new Object();
    private int headerItemPosition;
    private int footerItemPosition;
    private boolean itemFactoryLocked;
    private List dataList;
    private ArrayList<FixedPagerItemInfo> headerItemList;
    private ArrayList<FixedPagerItemInfo> footerItemList;
    private ArrayList<AssemblyPagerItemFactory> itemFactoryList;
    private boolean notifyOnChange = true;

    public AssemblyPagerAdapter(List dataList) {
        this.dataList = dataList;
    }

    public AssemblyPagerAdapter(Object[] dataArray) {
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedPagerItemInfo addHeaderItem(AssemblyPagerItemFactory headerFactory, Object data) {
        if (headerFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"headerFactory is nll or locked");
            return null;
        }
        headerFactory.setAdapter(this);
        FixedPagerItemInfo headerItemInfo = new FixedPagerItemInfo(headerFactory, data, true);
        headerItemInfo.setPosition(this.headerItemPosition++);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(2);
            }
            this.headerItemList.add(headerItemInfo);
        }
        return headerItemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addItemFactory(AssemblyPagerItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"itemFactory is nll or locked");
            return;
        }
        itemFactory.setAdapter(this);
        Object object = this.itemFactoryListLock;
        synchronized (object) {
            if (this.itemFactoryList == null) {
                this.itemFactoryList = new ArrayList(2);
            }
            this.itemFactoryList.add(itemFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FixedPagerItemInfo addFooterItem(AssemblyPagerItemFactory footerFactory, Object data) {
        if (footerFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"footerFactory is nll or locked");
            return null;
        }
        footerFactory.setAdapter(this);
        FixedPagerItemInfo footerItemInfo = new FixedPagerItemInfo(footerFactory, data, false);
        footerItemInfo.setPosition(this.footerItemPosition++);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(2);
            }
            this.footerItemList.add(footerItemInfo);
        }
        return footerItemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Object object, int index) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator comparator) {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headerEnabledChanged(FixedPagerItemInfo headerItemInfo) {
        if (headerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        if (headerItemInfo.isEnabled()) {
            Object object = this.headerItemListLock;
            synchronized (object) {
                this.headerItemList.add(headerItemInfo);
                Collections.sort(this.headerItemList, new Comparator<FixedPagerItemInfo>(){

                    @Override
                    public int compare(FixedPagerItemInfo lhs, FixedPagerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        } else {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void footerEnabledChanged(FixedPagerItemInfo footerItemInfo) {
        if (footerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        if (footerItemInfo.isEnabled()) {
            Object object = this.footerItemListLock;
            synchronized (object) {
                this.footerItemList.add(footerItemInfo);
                Collections.sort(this.footerItemList, new Comparator<FixedPagerItemInfo>(){

                    @Override
                    public int compare(FixedPagerItemInfo lhs, FixedPagerItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        } else {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeHeaderItem(FixedPagerItemInfo headerItemInfo) {
        if (headerItemInfo == null) {
            return;
        }
        if (headerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList != null && this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeFooterItem(FixedPagerItemInfo footerItemInfo) {
        if (footerItemInfo == null) {
            return;
        }
        if (footerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList != null && this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    public List<FixedPagerItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public List<AssemblyPagerItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public List<FixedPagerItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(List dataList) {
        Object object = this.itemListLock;
        synchronized (object) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }

    public int getCount() {
        this.itemFactoryLocked = true;
        return this.getHeaderItemCount() + this.getDataCount() + this.getFooterItemCount();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }

    @Nullable
    public Object getHeaderItem(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    @Nullable
    public Object getDataItem(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    @Nullable
    public Object getFooterItem(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            FixedPagerItemInfo fixedItemInfo = this.headerItemList.get(positionInHeaderList);
            View itemView = fixedItemInfo.getItemFactory().dispatchCreateView(container.getContext(), container, position, fixedItemInfo.getData());
            container.addView(itemView);
            return itemView;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getDataItem(positionInDataList);
            int size = this.itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyPagerItemFactory itemFactory = this.itemFactoryList.get(w);
                if (!itemFactory.isTarget(dataObject)) continue;
                View itemView = itemFactory.dispatchCreateView(container.getContext(), container, position, dataObject);
                container.addView(itemView);
                return itemView;
            }
            throw new IllegalStateException("Didn't find suitable AssemblyPagerItemFactory. position=" + position + ", dataObject=" + (dataObject != null ? dataObject.getClass().getName() : "null"));
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            FixedPagerItemInfo fixedItemInfo = this.footerItemList.get(positionInFooterList);
            View itemView = fixedItemInfo.getItemFactory().dispatchCreateView(container.getContext(), container, position, fixedItemInfo.getData());
            container.addView(itemView);
            return itemView;
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }
}

