/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.adapter;

import android.annotation.SuppressLint;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentPagerAdapter;
import android.support.v4.view.PagerAdapter;
import android.util.Log;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.panpf.adapter.AssemblyFragmentItemFactory;
import me.panpf.adapter.FixedFragmentItemInfo;

public class AssemblyFragmentPagerAdapter
extends FragmentPagerAdapter {
    private static final String TAG = "AssemblyFragmentPagerAdapter";
    private List dataList;
    private boolean itemFactoryLocked;
    private ArrayList<FixedFragmentItemInfo> headerItemList;
    private ArrayList<FixedFragmentItemInfo> footerItemList;
    private ArrayList<AssemblyFragmentItemFactory> itemFactoryList;

    public AssemblyFragmentPagerAdapter(FragmentManager fm, List dataList) {
        super(fm);
        this.dataList = dataList;
    }

    public AssemblyFragmentPagerAdapter(FragmentManager fm, Object[] dataArray) {
        super(fm);
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    @SuppressLint(value={"LongLogTag"})
    public void addHeaderItem(AssemblyFragmentItemFactory headerFactory, Object data) {
        if (headerFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"headerFactory is nll or locked");
            return;
        }
        headerFactory.setAdapter((PagerAdapter)this);
        if (this.headerItemList == null) {
            this.headerItemList = new ArrayList(2);
        }
        this.headerItemList.add(new FixedFragmentItemInfo(headerFactory, data));
    }

    @SuppressLint(value={"LongLogTag"})
    public void addItemFactory(AssemblyFragmentItemFactory itemFactory) {
        if (itemFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"itemFactory is nll or locked");
            return;
        }
        itemFactory.setAdapter((PagerAdapter)this);
        if (this.itemFactoryList == null) {
            this.itemFactoryList = new ArrayList(2);
        }
        this.itemFactoryList.add(itemFactory);
    }

    @SuppressLint(value={"LongLogTag"})
    public void addFooterItem(AssemblyFragmentItemFactory footerFactory, Object data) {
        if (footerFactory == null || this.itemFactoryLocked) {
            Log.w((String)TAG, (String)"footerFactory is nll or locked");
            return;
        }
        footerFactory.setAdapter((PagerAdapter)this);
        if (this.footerItemList == null) {
            this.footerItemList = new ArrayList(2);
        }
        this.footerItemList.add(new FixedFragmentItemInfo(footerFactory, data));
    }

    public List<FixedFragmentItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public List<AssemblyFragmentItemFactory> getItemFactoryList() {
        return this.itemFactoryList;
    }

    public List<FixedFragmentItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public List getDataList() {
        return this.dataList;
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    public int getItemFactoryCount() {
        return this.itemFactoryList != null ? this.itemFactoryList.size() : 0;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }

    public int getCount() {
        this.itemFactoryLocked = true;
        return this.getHeaderItemCount() + this.getDataCount() + this.getFooterItemCount();
    }

    @Nullable
    public Object getHeaderItem(int positionInHeaderList) {
        return this.headerItemList != null ? this.headerItemList.get(positionInHeaderList).getData() : null;
    }

    @Nullable
    public Object getDataItem(int positionInDataList) {
        return this.dataList != null ? this.dataList.get(positionInDataList) : null;
    }

    @Nullable
    public Object getFooterItem(int positionInFooterList) {
        return this.footerItemList != null ? this.footerItemList.get(positionInFooterList).getData() : null;
    }

    public Fragment getItem(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = position;
            FixedFragmentItemInfo fixedItemInfo = this.headerItemList.get(positionInHeaderList);
            return fixedItemInfo.getItemFactory().dispatchCreateFragment(position, fixedItemInfo.getData());
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            int positionInDataList = position - headerItemCount;
            Object dataObject = this.getDataItem(positionInDataList);
            int size = this.itemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyFragmentItemFactory itemFactory = this.itemFactoryList.get(w);
                if (!itemFactory.isTarget(dataObject)) continue;
                return itemFactory.dispatchCreateFragment(position, dataObject);
            }
            throw new IllegalStateException("Didn't find suitable AssemblyFragmentItemFactory. position=" + position + ", dataObject=" + (dataObject != null ? dataObject.getClass().getName() : "null"));
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = position - headerItemCount - dataCount;
            FixedFragmentItemInfo fixedItemInfo = this.footerItemList.get(positionInFooterList);
            return fixedItemInfo.getItemFactory().dispatchCreateFragment(position, fixedItemInfo.getData());
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }
}

