/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.assemblyadapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import me.panpf.assemblyadapter.AssemblyRecyclerItem;
import me.panpf.assemblyadapter.AssemblyRecyclerItemFactory;
import me.panpf.assemblyadapter.OnRecyclerLoadMoreListener;

public abstract class AssemblyLoadMoreRecyclerItemFactory
extends AssemblyRecyclerItemFactory<AssemblyLoadMoreRecyclerItem> {
    private boolean paused;
    private boolean end;
    private OnRecyclerLoadMoreListener eventListener;
    private AssemblyLoadMoreRecyclerItem loadMoreItem;

    public AssemblyLoadMoreRecyclerItemFactory(OnRecyclerLoadMoreListener eventListener) {
        this.eventListener = eventListener;
    }

    public AssemblyLoadMoreRecyclerItemFactory fullSpan(RecyclerView recyclerView) {
        super.fullSpan(recyclerView);
        return this;
    }

    public AssemblyLoadMoreRecyclerItemFactory setSpanSize(int spanSize) {
        super.setSpanSize(spanSize);
        return this;
    }

    public void loadMoreFinished(boolean end) {
        this.paused = false;
        this.end = end;
        if (this.loadMoreItem != null) {
            if (end) {
                this.loadMoreItem.showEnd();
            } else {
                this.loadMoreItem.showLoading();
            }
        }
    }

    public void loadMoreFailed() {
        this.paused = false;
        if (this.loadMoreItem != null) {
            this.loadMoreItem.showErrorRetry();
        }
    }

    @Override
    public boolean isTarget(Object data) {
        return true;
    }

    public abstract class AssemblyLoadMoreRecyclerItem<T>
    extends AssemblyRecyclerItem<T> {
        public AssemblyLoadMoreRecyclerItem(int itemLayoutId, ViewGroup parent) {
            super(itemLayoutId, parent);
            AssemblyLoadMoreRecyclerItemFactory.this.loadMoreItem = this;
        }

        public AssemblyLoadMoreRecyclerItem(View convertView) {
            super(convertView);
            AssemblyLoadMoreRecyclerItemFactory.this.loadMoreItem = this;
        }

        public abstract View getErrorRetryView();

        public abstract void showLoading();

        public abstract void showErrorRetry();

        public abstract void showEnd();

        @Override
        public void onConfigViews(Context context) {
            View errorView = this.getErrorRetryView();
            if (errorView != null) {
                errorView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (AssemblyLoadMoreRecyclerItemFactory.this.eventListener != null) {
                            AssemblyLoadMoreRecyclerItemFactory.this.paused = false;
                            AssemblyLoadMoreRecyclerItem.this.setData(AssemblyLoadMoreRecyclerItem.this.getLayoutPosition(), AssemblyLoadMoreRecyclerItem.this.getData());
                        }
                    }
                });
            }
        }

        @Override
        public void onSetData(int position, T t) {
            if (AssemblyLoadMoreRecyclerItemFactory.this.end) {
                this.showEnd();
            } else {
                this.showLoading();
                if (AssemblyLoadMoreRecyclerItemFactory.this.eventListener != null && !AssemblyLoadMoreRecyclerItemFactory.this.paused) {
                    AssemblyLoadMoreRecyclerItemFactory.this.paused = true;
                    AssemblyLoadMoreRecyclerItemFactory.this.eventListener.onLoadMore(AssemblyLoadMoreRecyclerItemFactory.this.getAdapter());
                }
            }
        }
    }
}

