/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.assemblyadapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import me.panpf.assemblyadapter.AssemblyItem;
import me.panpf.assemblyadapter.AssemblyItemFactory;
import me.panpf.assemblyadapter.OnLoadMoreListener;

public abstract class AssemblyLoadMoreItemFactory
extends AssemblyItemFactory<AssemblyLoadMoreItem> {
    private boolean paused;
    private boolean end;
    private OnLoadMoreListener eventListener;
    private AssemblyLoadMoreItem loadMoreItem;

    public AssemblyLoadMoreItemFactory(OnLoadMoreListener eventListener) {
        this.eventListener = eventListener;
    }

    public void loadMoreFinished(boolean end) {
        this.paused = false;
        this.end = end;
        if (this.loadMoreItem != null) {
            if (end) {
                this.loadMoreItem.showEnd();
            } else {
                this.loadMoreItem.showLoading();
            }
        }
    }

    public void loadMoreFailed() {
        this.paused = false;
        if (this.loadMoreItem != null) {
            this.loadMoreItem.showErrorRetry();
        }
    }

    @Override
    public boolean isTarget(Object data) {
        return true;
    }

    public abstract class AssemblyLoadMoreItem<T>
    extends AssemblyItem<T> {
        public AssemblyLoadMoreItem(int itemLayoutId, ViewGroup parent) {
            super(itemLayoutId, parent);
            AssemblyLoadMoreItemFactory.this.loadMoreItem = this;
        }

        public AssemblyLoadMoreItem(View convertView) {
            super(convertView);
            AssemblyLoadMoreItemFactory.this.loadMoreItem = this;
        }

        public abstract View getErrorRetryView();

        public abstract void showLoading();

        public abstract void showErrorRetry();

        public abstract void showEnd();

        @Override
        public void onConfigViews(Context context) {
            View errorView = this.getErrorRetryView();
            if (errorView != null) {
                errorView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (AssemblyLoadMoreItemFactory.this.eventListener != null) {
                            AssemblyLoadMoreItemFactory.this.paused = false;
                            AssemblyLoadMoreItem.this.setData(AssemblyLoadMoreItem.this.getPosition(), AssemblyLoadMoreItem.this.getData());
                        }
                    }
                });
            }
        }

        @Override
        public void onSetData(int position, T t) {
            if (AssemblyLoadMoreItemFactory.this.end) {
                this.showEnd();
            } else {
                this.showLoading();
                if (AssemblyLoadMoreItemFactory.this.eventListener != null && !AssemblyLoadMoreItemFactory.this.paused) {
                    AssemblyLoadMoreItemFactory.this.paused = true;
                    AssemblyLoadMoreItemFactory.this.eventListener.onLoadMore(AssemblyLoadMoreItemFactory.this.getAdapter());
                }
            }
        }
    }
}

