/*
 * Decompiled with CFR 0.152.
 */
package me.panpf.assemblyadapter;

import android.annotation.SuppressLint;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import me.panpf.assemblyadapter.AssemblyChildItem;
import me.panpf.assemblyadapter.AssemblyChildItemFactory;
import me.panpf.assemblyadapter.AssemblyGroup;
import me.panpf.assemblyadapter.AssemblyGroupItem;
import me.panpf.assemblyadapter.AssemblyGroupItemFactory;
import me.panpf.assemblyadapter.AssemblyLoadMoreGroupItemFactory;
import me.panpf.assemblyadapter.FixedGroupItemInfo;
import me.panpf.assemblyadapter.LoadMoreFixedGroupItemInfo;

public class AssemblyExpandableAdapter
extends BaseExpandableListAdapter {
    private static final String TAG = "AssemblyExpandableAdapter";
    private final Object itemListLock = new Object();
    private final Object headerItemListLock = new Object();
    private final Object groupItemFactoryListLock = new Object();
    private final Object childItemFactoryListLock = new Object();
    private final Object footerItemListLock = new Object();
    private int groupTypeIndex = 0;
    private int childTypeIndex = 0;
    private int headerItemPosition;
    private int footerItemPosition;
    private boolean groupItemFactoryLocked;
    private boolean childItemFactoryLocked;
    private List dataList;
    private ExpandCallback expandCallback;
    private ArrayList<FixedGroupItemInfo> headerItemList;
    private ArrayList<FixedGroupItemInfo> footerItemList;
    private ArrayList<AssemblyGroupItemFactory> groupItemFactoryList;
    private ArrayList<AssemblyChildItemFactory> childItemFactoryList;
    private SparseArray<Object> groupItemFactoryArray;
    private SparseArray<Object> childItemFactoryArray;
    private LoadMoreFixedGroupItemInfo loadMoreFixedItemInfo;
    private boolean notifyOnChange = true;

    public AssemblyExpandableAdapter(List dataList) {
        this.dataList = dataList;
    }

    public AssemblyExpandableAdapter(Object[] dataArray) {
        if (dataArray != null && dataArray.length > 0) {
            this.dataList = new ArrayList(dataArray.length);
            Collections.addAll(this.dataList, dataArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"LongLogTag"})
    public FixedGroupItemInfo addHeaderItem(AssemblyGroupItemFactory headerFactory, Object data) {
        if (headerFactory == null || this.groupItemFactoryLocked) {
            Log.w((String)TAG, (String)"headerFactory is nll or item factory locked");
            return null;
        }
        headerFactory.setAdapter(this);
        headerFactory.setItemType(this.groupTypeIndex++);
        FixedGroupItemInfo headerItemInfo = new FixedGroupItemInfo(headerFactory, data, true);
        headerItemInfo.setPosition(this.headerItemPosition++);
        if (this.groupItemFactoryArray == null) {
            this.groupItemFactoryArray = new SparseArray();
        }
        this.groupItemFactoryArray.put(headerFactory.getItemType(), (Object)headerItemInfo);
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList == null) {
                this.headerItemList = new ArrayList(2);
            }
            this.headerItemList.add(headerItemInfo);
        }
        return headerItemInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGroupItemFactory(AssemblyGroupItemFactory groupItemFactory) {
        if (groupItemFactory == null || this.groupItemFactoryLocked) {
            throw new IllegalStateException("groupItemFactory is null or item factory locked");
        }
        groupItemFactory.setAdapter(this);
        groupItemFactory.setItemType(this.groupTypeIndex++);
        if (this.groupItemFactoryArray == null) {
            this.groupItemFactoryArray = new SparseArray();
        }
        this.groupItemFactoryArray.put(groupItemFactory.getItemType(), (Object)groupItemFactory);
        Object object = this.groupItemFactoryListLock;
        synchronized (object) {
            if (this.groupItemFactoryList == null) {
                this.groupItemFactoryList = new ArrayList(5);
            }
            this.groupItemFactoryList.add(groupItemFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildItemFactory(AssemblyChildItemFactory childItemFactory) {
        if (childItemFactory == null || this.childItemFactoryLocked) {
            throw new IllegalStateException("childItemFactory is null or item factory locked");
        }
        childItemFactory.setAdapter(this);
        childItemFactory.setItemType(this.childTypeIndex++);
        if (this.childItemFactoryArray == null) {
            this.childItemFactoryArray = new SparseArray();
        }
        this.childItemFactoryArray.put(childItemFactory.getItemType(), (Object)childItemFactory);
        Object object = this.childItemFactoryListLock;
        synchronized (object) {
            if (this.childItemFactoryList == null) {
                this.childItemFactoryList = new ArrayList(5);
            }
            this.childItemFactoryList.add(childItemFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressLint(value={"LongLogTag"})
    public FixedGroupItemInfo addFooterItem(AssemblyGroupItemFactory footerFactory, Object data) {
        if (footerFactory == null || this.groupItemFactoryLocked) {
            Log.w((String)TAG, (String)"footerFactory is nll or item factory locked");
            return null;
        }
        footerFactory.setAdapter(this);
        footerFactory.setItemType(this.groupTypeIndex++);
        FixedGroupItemInfo footerItemInfo = new FixedGroupItemInfo(footerFactory, data, false);
        footerItemInfo.setPosition(this.footerItemPosition++);
        if (this.groupItemFactoryArray == null) {
            this.groupItemFactoryArray = new SparseArray();
        }
        this.groupItemFactoryArray.put(footerFactory.getItemType(), (Object)footerItemInfo);
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList == null) {
                this.footerItemList = new ArrayList(2);
            }
            this.footerItemList.add(footerItemInfo);
        }
        return footerItemInfo;
    }

    @SuppressLint(value={"LongLogTag"})
    public LoadMoreFixedGroupItemInfo setLoadMoreItem(AssemblyLoadMoreGroupItemFactory loadMoreItemFactory, Object data) {
        if (loadMoreItemFactory == null || this.groupItemFactoryLocked) {
            Log.w((String)TAG, (String)"loadMoreItemFactory is null or item factory locked");
            return null;
        }
        loadMoreItemFactory.setAdapter(this);
        if (this.loadMoreFixedItemInfo != null) {
            loadMoreItemFactory.setItemType(this.loadMoreFixedItemInfo.getItemFactory().getItemType());
        } else {
            loadMoreItemFactory.setItemType(this.groupTypeIndex++);
        }
        loadMoreItemFactory.loadMoreFinished(false);
        LoadMoreFixedGroupItemInfo loadMoreFixedItemInfo = new LoadMoreFixedGroupItemInfo(loadMoreItemFactory, data, false);
        if (this.groupItemFactoryArray == null) {
            this.groupItemFactoryArray = new SparseArray();
        }
        this.groupItemFactoryArray.put(loadMoreItemFactory.getItemType(), (Object)loadMoreFixedItemInfo);
        this.loadMoreFixedItemInfo = loadMoreFixedItemInfo;
        return this.loadMoreFixedItemInfo;
    }

    public LoadMoreFixedGroupItemInfo setLoadMoreItem(AssemblyLoadMoreGroupItemFactory loadMoreItemFactory) {
        return this.setLoadMoreItem(loadMoreItemFactory, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Collection collection) {
        if (collection == null || collection.size() == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(collection.size());
            }
            this.dataList.addAll(collection);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAll(Object ... items) {
        if (items == null || items.length == 0) {
            return;
        }
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList == null) {
                this.dataList = new ArrayList(items.length);
            }
            Collections.addAll(this.dataList, items);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Object object, int index) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList == null) {
                this.dataList = new ArrayList();
            }
            this.dataList.add(index, object);
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object object) {
        if (object == null) {
            return;
        }
        Object object2 = this.itemListLock;
        synchronized (object2) {
            if (this.dataList != null) {
                this.dataList.remove(object);
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                this.dataList.clear();
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sort(Comparator comparator) {
        Object object = this.itemListLock;
        synchronized (object) {
            if (this.dataList != null) {
                Collections.sort(this.dataList, comparator);
            }
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public void setDisableLoadMore(boolean disableLoadMore) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.setEnabled(!disableLoadMore);
        }
    }

    @Deprecated
    public void setLoadMoreEnd(boolean loadMoreEnd) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFinished(loadMoreEnd);
        }
    }

    public void loadMoreFinished(boolean loadMoreEnd) {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFinished(loadMoreEnd);
        }
    }

    public void loadMoreFailed() {
        if (this.loadMoreFixedItemInfo != null) {
            this.loadMoreFixedItemInfo.loadMoreFailed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void headerEnabledChanged(FixedGroupItemInfo headerItemInfo) {
        if (headerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        if (headerItemInfo.isEnabled()) {
            Object object = this.headerItemListLock;
            synchronized (object) {
                this.headerItemList.add(headerItemInfo);
                Collections.sort(this.headerItemList, new Comparator<FixedGroupItemInfo>(){

                    @Override
                    public int compare(FixedGroupItemInfo lhs, FixedGroupItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        } else {
            Object object = this.headerItemListLock;
            synchronized (object) {
                if (this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void footerEnabledChanged(FixedGroupItemInfo footerItemInfo) {
        if (footerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        if (footerItemInfo.isEnabled()) {
            Object object = this.footerItemListLock;
            synchronized (object) {
                this.footerItemList.add(footerItemInfo);
                Collections.sort(this.footerItemList, new Comparator<FixedGroupItemInfo>(){

                    @Override
                    public int compare(FixedGroupItemInfo lhs, FixedGroupItemInfo rhs) {
                        return lhs.getPosition() - rhs.getPosition();
                    }
                });
            }
            if (this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        } else {
            Object object = this.footerItemListLock;
            synchronized (object) {
                if (this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                    this.notifyDataSetChanged();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeHeaderItem(FixedGroupItemInfo headerItemInfo) {
        if (headerItemInfo == null) {
            return;
        }
        if (headerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        Object object = this.headerItemListLock;
        synchronized (object) {
            if (this.headerItemList != null && this.headerItemList.remove(headerItemInfo) && this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeFooterItem(FixedGroupItemInfo footerItemInfo) {
        if (footerItemInfo == null) {
            return;
        }
        if (footerItemInfo.getItemFactory().getAdapter() != this) {
            return;
        }
        Object object = this.footerItemListLock;
        synchronized (object) {
            if (this.footerItemList != null && this.footerItemList.remove(footerItemInfo) && this.notifyOnChange) {
                this.notifyDataSetChanged();
            }
        }
    }

    public List<FixedGroupItemInfo> getHeaderItemList() {
        return this.headerItemList;
    }

    public List<AssemblyGroupItemFactory> getGroupItemFactoryList() {
        return this.groupItemFactoryList;
    }

    public List<AssemblyChildItemFactory> getChildItemFactoryList() {
        return this.childItemFactoryList;
    }

    public List<FixedGroupItemInfo> getFooterItemList() {
        return this.footerItemList;
    }

    public List getDataList() {
        return this.dataList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDataList(List dataList) {
        Object object = this.itemListLock;
        synchronized (object) {
            this.dataList = dataList;
        }
        if (this.notifyOnChange) {
            this.notifyDataSetChanged();
        }
    }

    public int getHeaderItemCount() {
        return this.headerItemList != null ? this.headerItemList.size() : 0;
    }

    public int getGroupItemFactoryCount() {
        return this.groupItemFactoryList != null ? this.groupItemFactoryList.size() : 0;
    }

    public int getChildItemFactoryCount() {
        return this.childItemFactoryList != null ? this.childItemFactoryList.size() : 0;
    }

    public int getFooterItemCount() {
        return this.footerItemList != null ? this.footerItemList.size() : 0;
    }

    public boolean hasLoadMoreFooter() {
        return this.loadMoreFixedItemInfo != null && this.loadMoreFixedItemInfo.isEnabled();
    }

    public int getDataCount() {
        return this.dataList != null ? this.dataList.size() : 0;
    }

    public boolean isNotifyOnChange() {
        return this.notifyOnChange;
    }

    public void setNotifyOnChange(boolean notifyOnChange) {
        this.notifyOnChange = notifyOnChange;
    }

    public void setExpandCallback(ExpandCallback expandCallback) {
        this.expandCallback = expandCallback;
    }

    public int getPositionInPart(int position) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (position >= headerStartPosition && position <= headerEndPosition && headerItemCount > 0) {
            return position;
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (position >= dataStartPosition && position <= dataEndPosition && dataCount > 0) {
            return position - headerItemCount;
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (position >= footerStartPosition && position <= footerEndPosition && footerItemCount > 0) {
            return position - headerItemCount - dataCount;
        }
        if (dataCount > 0 && this.hasLoadMoreFooter() && position == this.getGroupCount() - 1) {
            return 0;
        }
        throw new IllegalArgumentException("illegal position: " + position);
    }

    public int getGroupCount() {
        int headerItemCount = this.getHeaderItemCount();
        int dataCount = this.getDataCount();
        int footerItemCount = this.getFooterItemCount();
        if (dataCount > 0) {
            return headerItemCount + dataCount + footerItemCount + (this.hasLoadMoreFooter() ? 1 : 0);
        }
        return headerItemCount + footerItemCount;
    }

    public Object getGroup(int groupPosition) {
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (groupPosition >= headerStartPosition && groupPosition <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = groupPosition;
            return this.headerItemList.get(positionInHeaderList).getData();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (groupPosition >= dataStartPosition && groupPosition <= dataEndPosition && dataCount > 0) {
            int positionInDataList = groupPosition - headerItemCount;
            return this.dataList.get(positionInDataList);
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (groupPosition >= footerStartPosition && groupPosition <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = groupPosition - headerItemCount - dataCount;
            return this.footerItemList.get(positionInFooterList).getData();
        }
        if (dataCount > 0 && this.hasLoadMoreFooter() && groupPosition == this.getGroupCount() - 1) {
            return this.loadMoreFixedItemInfo.getData();
        }
        return null;
    }

    public long getGroupId(int groupPosition) {
        return groupPosition;
    }

    @SuppressLint(value={"LongLogTag"})
    public int getChildrenCount(int groupPosition) {
        Object groupObject = this.getGroup(groupPosition);
        if (groupObject != null && groupObject instanceof AssemblyGroup) {
            return ((AssemblyGroup)groupObject).getChildCount();
        }
        return 0;
    }

    @SuppressLint(value={"LongLogTag"})
    public Object getChild(int groupPosition, int childPosition) {
        Object groupDataObject = this.getGroup(groupPosition);
        if (groupDataObject == null) {
            return null;
        }
        if (!(groupDataObject instanceof AssemblyGroup)) {
            throw new IllegalArgumentException("group object must implements AssemblyGroup interface. groupPosition=" + groupPosition + ", groupDataObject=" + groupDataObject.getClass().getName());
        }
        return ((AssemblyGroup)groupDataObject).getChild(childPosition);
    }

    public long getChildId(int groupPosition, int childPosition) {
        return childPosition;
    }

    public int getGroupTypeCount() {
        this.groupItemFactoryLocked = true;
        return this.groupTypeIndex > 0 ? this.groupTypeIndex : super.getGroupTypeCount();
    }

    @SuppressLint(value={"LongLogTag"})
    public int getGroupType(int groupPosition) {
        if (this.getGroupItemFactoryCount() <= 0) {
            throw new IllegalStateException("You need to configure AssemblyGroupItemFactory use addGroupItemFactory method");
        }
        this.groupItemFactoryLocked = true;
        int headerItemCount = this.getHeaderItemCount();
        int headerStartPosition = 0;
        int headerEndPosition = headerItemCount - 1;
        if (groupPosition >= headerStartPosition && groupPosition <= headerEndPosition && headerItemCount > 0) {
            int positionInHeaderList = groupPosition;
            return this.headerItemList.get(positionInHeaderList).getItemFactory().getItemType();
        }
        int dataCount = this.getDataCount();
        int dataStartPosition = headerEndPosition + 1;
        int dataEndPosition = headerEndPosition + dataCount;
        if (groupPosition >= dataStartPosition && groupPosition <= dataEndPosition && dataCount > 0) {
            int positionInDataList = groupPosition - headerItemCount;
            Object groupDataObject = this.dataList.get(positionInDataList);
            int size = this.groupItemFactoryList.size();
            for (int w = 0; w < size; ++w) {
                AssemblyGroupItemFactory itemFactory = this.groupItemFactoryList.get(w);
                if (!itemFactory.isTarget(groupDataObject)) continue;
                return itemFactory.getItemType();
            }
            throw new IllegalStateException("Didn't find suitable AssemblyGroupItemFactory. positionInDataList=" + positionInDataList + ", groupDataObject=" + (groupDataObject != null ? groupDataObject.getClass().getName() : "null"));
        }
        int footerItemCount = this.getFooterItemCount();
        int footerStartPosition = dataEndPosition + 1;
        int footerEndPosition = dataEndPosition + footerItemCount;
        if (groupPosition >= footerStartPosition && groupPosition <= footerEndPosition && footerItemCount > 0) {
            int positionInFooterList = groupPosition - headerItemCount - dataCount;
            return this.footerItemList.get(positionInFooterList).getItemFactory().getItemType();
        }
        if (dataCount > 0 && this.hasLoadMoreFooter() && groupPosition == this.getGroupCount() - 1) {
            return this.loadMoreFixedItemInfo.getItemFactory().getItemType();
        }
        throw new IllegalStateException("not found match viewType, groupPosition: " + groupPosition);
    }

    public int getChildTypeCount() {
        this.childItemFactoryLocked = true;
        return this.childTypeIndex > 0 ? this.childTypeIndex : super.getChildTypeCount();
    }

    @SuppressLint(value={"LongLogTag"})
    public int getChildType(int groupPosition, int childPosition) {
        if (this.getChildItemFactoryCount() <= 0) {
            throw new IllegalStateException("You need to configure AssemblyChildItemFactory use addChildItemFactory method");
        }
        this.childItemFactoryLocked = true;
        Object childDataObject = this.getChild(groupPosition, childPosition);
        int size = this.childItemFactoryList.size();
        for (int w = 0; w < size; ++w) {
            AssemblyChildItemFactory childItemFactory = this.childItemFactoryList.get(w);
            if (!childItemFactory.isTarget(childDataObject)) continue;
            return childItemFactory.getItemType();
        }
        throw new IllegalStateException("Didn't find suitable AssemblyChildItemFactory. groupPosition=" + groupPosition + ", childPosition=" + childPosition + ", childDataObject=" + (childDataObject != null ? childDataObject.getClass().getName() : "null"));
    }

    public boolean hasStableIds() {
        return this.expandCallback != null && this.expandCallback.hasStableIds();
    }

    public boolean isChildSelectable(int groupPosition, int childPosition) {
        return this.expandCallback != null && this.expandCallback.isChildSelectable(groupPosition, childPosition);
    }

    @SuppressLint(value={"LongLogTag"})
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        AssemblyGroupItem groupItem;
        if (convertView == null) {
            groupItem = this.createGroupItem(parent, this.getGroupType(groupPosition));
            convertView = groupItem.getItemView();
            convertView.setTag((Object)groupItem);
        } else {
            groupItem = (AssemblyGroupItem)convertView.getTag();
        }
        this.bindGroupItem(groupItem, isExpanded, groupPosition);
        return convertView;
    }

    private AssemblyGroupItem createGroupItem(ViewGroup parent, int viewType) {
        Object item = this.groupItemFactoryArray.get(viewType);
        if (item instanceof AssemblyGroupItemFactory) {
            AssemblyGroupItemFactory itemFactory = (AssemblyGroupItemFactory)item;
            return itemFactory.dispatchCreateAssemblyItem(parent);
        }
        if (item instanceof FixedGroupItemInfo) {
            FixedGroupItemInfo fixedItemInfo = (FixedGroupItemInfo)item;
            return fixedItemInfo.getItemFactory().dispatchCreateAssemblyItem(parent);
        }
        throw new IllegalStateException("unknown groupViewType: " + viewType + ", itemFactory: " + (item != null ? item.getClass().getName() : "null"));
    }

    public void bindGroupItem(AssemblyGroupItem groupItem, boolean isExpanded, int groupPosition) {
        groupItem.setData(groupPosition, isExpanded, this.getGroup(groupPosition));
    }

    @SuppressLint(value={"LongLogTag"})
    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        AssemblyChildItem childItem;
        if (convertView == null) {
            childItem = this.createChildItem(parent, this.getChildType(groupPosition, childPosition));
            convertView = childItem.getItemView();
            convertView.setTag((Object)childItem);
        } else {
            childItem = (AssemblyChildItem)convertView.getTag();
        }
        this.bindChildItem(childItem, groupPosition, childPosition, isLastChild);
        return convertView;
    }

    private AssemblyChildItem createChildItem(ViewGroup parent, int viewType) {
        Object item = this.childItemFactoryArray.get(viewType);
        if (item instanceof AssemblyChildItemFactory) {
            AssemblyChildItemFactory itemFactory = (AssemblyChildItemFactory)item;
            return itemFactory.dispatchCreateAssemblyItem(parent);
        }
        throw new IllegalStateException("unknown childViewType: " + viewType + ", itemFactory: " + (item != null ? item.getClass().getName() : "null"));
    }

    private void bindChildItem(AssemblyChildItem childItem, int groupPosition, int childPosition, boolean isLastChild) {
        childItem.setData(groupPosition, childPosition, isLastChild, this.getChild(groupPosition, childPosition));
    }

    public static interface ExpandCallback {
        public boolean hasStableIds();

        public boolean isChildSelectable(int var1, int var2);
    }
}

