/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.Button;
import androidx.annotation.NonNull;

@SuppressLint(value={"AppCompatCustomView"})
public class NavigationBarButton
extends Button {
    public NavigationBarButton(Context context) {
        super(context);
        this.init();
    }

    public NavigationBarButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        if (Build.VERSION.SDK_INT >= 17) {
            Drawable[] drawables = this.getCompoundDrawablesRelative();
            for (int i = 0; i < drawables.length; ++i) {
                if (drawables[i] == null) continue;
                drawables[i] = TintedDrawable.wrap(drawables[i]);
            }
            this.setCompoundDrawablesRelativeWithIntrinsicBounds(drawables[0], drawables[1], drawables[2], drawables[3]);
        }
    }

    public void setCompoundDrawables(Drawable left, Drawable top, Drawable right, Drawable bottom) {
        if (left != null) {
            left = TintedDrawable.wrap(left);
        }
        if (top != null) {
            top = TintedDrawable.wrap(top);
        }
        if (right != null) {
            right = TintedDrawable.wrap(right);
        }
        if (bottom != null) {
            bottom = TintedDrawable.wrap(bottom);
        }
        super.setCompoundDrawables(left, top, right, bottom);
        this.tintDrawables();
    }

    public void setCompoundDrawablesRelative(Drawable start, Drawable top, Drawable end, Drawable bottom) {
        if (start != null) {
            start = TintedDrawable.wrap(start);
        }
        if (top != null) {
            top = TintedDrawable.wrap(top);
        }
        if (end != null) {
            end = TintedDrawable.wrap(end);
        }
        if (bottom != null) {
            bottom = TintedDrawable.wrap(bottom);
        }
        super.setCompoundDrawablesRelative(start, top, end, bottom);
        this.tintDrawables();
    }

    public void setTextColor(ColorStateList colors) {
        super.setTextColor(colors);
        this.tintDrawables();
    }

    private void tintDrawables() {
        ColorStateList textColors = this.getTextColors();
        if (textColors != null) {
            for (Drawable drawable : this.getAllCompoundDrawables()) {
                if (!(drawable instanceof TintedDrawable)) continue;
                ((TintedDrawable)drawable).setTintListCompat(textColors);
            }
            this.invalidate();
        }
    }

    private Drawable[] getAllCompoundDrawables() {
        Drawable[] drawables = new Drawable[6];
        Drawable[] compoundDrawables = this.getCompoundDrawables();
        drawables[0] = compoundDrawables[0];
        drawables[1] = compoundDrawables[1];
        drawables[2] = compoundDrawables[2];
        drawables[3] = compoundDrawables[3];
        if (Build.VERSION.SDK_INT >= 17) {
            Drawable[] compoundDrawablesRelative = this.getCompoundDrawablesRelative();
            drawables[4] = compoundDrawablesRelative[0];
            drawables[5] = compoundDrawablesRelative[2];
        }
        return drawables;
    }

    private static class TintedDrawable
    extends LayerDrawable {
        private ColorStateList mTintList = null;

        public static TintedDrawable wrap(Drawable drawable) {
            if (drawable instanceof TintedDrawable) {
                return (TintedDrawable)drawable;
            }
            return new TintedDrawable(drawable.mutate());
        }

        TintedDrawable(Drawable wrapped) {
            super(new Drawable[]{wrapped});
        }

        public boolean isStateful() {
            return true;
        }

        public boolean setState(@NonNull int[] stateSet) {
            boolean needsInvalidate = super.setState(stateSet);
            boolean needsInvalidateForState = this.updateState();
            return needsInvalidate || needsInvalidateForState;
        }

        public void setTintListCompat(ColorStateList colors) {
            this.mTintList = colors;
            if (this.updateState()) {
                this.invalidateSelf();
            }
        }

        private boolean updateState() {
            if (this.mTintList != null) {
                int color = this.mTintList.getColorForState(this.getState(), 0);
                this.setColorFilter(color, PorterDuff.Mode.SRC_IN);
                return true;
            }
            return false;
        }
    }
}

