/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewOutlineProvider;
import android.widget.FrameLayout;
import com.android.setupwizardlib.R;

public class Illustration
extends FrameLayout {
    private float mBaselineGridSize;
    private Drawable mBackground;
    private Drawable mIllustration;
    private final Rect mViewBounds = new Rect();
    private final Rect mIllustrationBounds = new Rect();
    private float mScale = 1.0f;
    private float mAspectRatio = 0.0f;

    public Illustration(Context context) {
        super(context);
        this.init(null, 0);
    }

    public Illustration(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    @TargetApi(value=11)
    public Illustration(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs, defStyleAttr);
    }

    private void init(AttributeSet attrs, int defStyleAttr) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.SuwIllustration, defStyleAttr, 0);
            this.mAspectRatio = a.getFloat(R.styleable.SuwIllustration_suwAspectRatio, 0.0f);
            a.recycle();
        }
        this.mBaselineGridSize = this.getResources().getDisplayMetrics().density * 8.0f;
        this.setWillNotDraw(false);
    }

    public void setBackgroundDrawable(Drawable background) {
        if (background == this.mBackground) {
            return;
        }
        this.mBackground = background;
        this.invalidate();
        this.requestLayout();
    }

    public void setIllustration(Drawable illustration) {
        if (illustration == this.mIllustration) {
            return;
        }
        this.mIllustration = illustration;
        this.invalidate();
        this.requestLayout();
    }

    public void setAspectRatio(float aspectRatio) {
        this.mAspectRatio = aspectRatio;
        this.invalidate();
        this.requestLayout();
    }

    @Deprecated
    public void setForeground(Drawable d) {
        this.setIllustration(d);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        if (this.mAspectRatio != 0.0f) {
            int parentWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int illustrationHeight = (int)((float)parentWidth / this.mAspectRatio);
            illustrationHeight = (int)((float)illustrationHeight - (float)illustrationHeight % this.mBaselineGridSize);
            this.setPadding(0, illustrationHeight, 0, 0);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            this.setOutlineProvider(ViewOutlineProvider.BOUNDS);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int layoutWidth = right - left;
        int layoutHeight = bottom - top;
        if (this.mIllustration != null) {
            int intrinsicWidth = this.mIllustration.getIntrinsicWidth();
            int intrinsicHeight = this.mIllustration.getIntrinsicHeight();
            this.mViewBounds.set(0, 0, layoutWidth, layoutHeight);
            if (this.mAspectRatio != 0.0f) {
                this.mScale = (float)layoutWidth / (float)intrinsicWidth;
                intrinsicWidth = layoutWidth;
                intrinsicHeight = (int)((float)intrinsicHeight * this.mScale);
            }
            Gravity.apply((int)55, (int)intrinsicWidth, (int)intrinsicHeight, (Rect)this.mViewBounds, (Rect)this.mIllustrationBounds);
            this.mIllustration.setBounds(this.mIllustrationBounds);
        }
        if (this.mBackground != null) {
            this.mBackground.setBounds(0, 0, (int)Math.ceil((float)layoutWidth / this.mScale), (int)Math.ceil((float)(layoutHeight - this.mIllustrationBounds.height()) / this.mScale));
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void onDraw(Canvas canvas) {
        if (this.mBackground != null) {
            canvas.save();
            canvas.translate(0.0f, (float)this.mIllustrationBounds.height());
            canvas.scale(this.mScale, this.mScale, 0.0f, 0.0f);
            if (Build.VERSION.SDK_INT > 17 && this.shouldMirrorDrawable(this.mBackground, this.getLayoutDirection())) {
                canvas.scale(-1.0f, 1.0f);
                canvas.translate((float)(-this.mBackground.getBounds().width()), 0.0f);
            }
            this.mBackground.draw(canvas);
            canvas.restore();
        }
        if (this.mIllustration != null) {
            canvas.save();
            if (Build.VERSION.SDK_INT > 17 && this.shouldMirrorDrawable(this.mIllustration, this.getLayoutDirection())) {
                canvas.scale(-1.0f, 1.0f);
                canvas.translate((float)(-this.mIllustrationBounds.width()), 0.0f);
            }
            this.mIllustration.draw(canvas);
            canvas.restore();
        }
        super.onDraw(canvas);
    }

    private boolean shouldMirrorDrawable(Drawable drawable, int layoutDirection) {
        if (layoutDirection == 1) {
            if (Build.VERSION.SDK_INT >= 19) {
                return drawable.isAutoMirrored();
            }
            if (Build.VERSION.SDK_INT >= 17) {
                int flags = this.getContext().getApplicationInfo().flags;
                return (flags & 0x400000) != 0;
            }
        }
        return false;
    }
}

