/*
 * Decompiled with CFR 0.152.
 */
package com.android.setupwizardlib.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.StyleRes;
import androidx.annotation.VisibleForTesting;
import com.android.setupwizardlib.R;
import java.util.Arrays;

public class WizardManagerHelper {
    private static final String ACTION_NEXT = "com.android.wizard.NEXT";
    @VisibleForTesting
    static final String EXTRA_SCRIPT_URI = "scriptUri";
    @VisibleForTesting
    static final String EXTRA_ACTION_ID = "actionId";
    @VisibleForTesting
    static final String EXTRA_WIZARD_BUNDLE = "wizardBundle";
    private static final String EXTRA_RESULT_CODE = "com.android.setupwizard.ResultCode";
    @VisibleForTesting
    static final String EXTRA_IS_FIRST_RUN = "firstRun";
    @VisibleForTesting
    static final String EXTRA_IS_DEFERRED_SETUP = "deferredSetup";
    @VisibleForTesting
    static final String EXTRA_IS_PRE_DEFERRED_SETUP = "preDeferredSetup";
    public static final String EXTRA_THEME = "theme";
    public static final String EXTRA_USE_IMMERSIVE_MODE = "useImmersiveMode";
    public static final String SETTINGS_GLOBAL_DEVICE_PROVISIONED = "device_provisioned";
    public static final String SETTINGS_SECURE_USER_SETUP_COMPLETE = "user_setup_complete";
    public static final String THEME_HOLO = "holo";
    public static final String THEME_HOLO_LIGHT = "holo_light";
    public static final String THEME_MATERIAL = "material";
    public static final String THEME_MATERIAL_LIGHT = "material_light";
    public static final String THEME_GLIF = "glif";
    public static final String THEME_GLIF_LIGHT = "glif_light";
    public static final String THEME_GLIF_V2 = "glif_v2";
    public static final String THEME_GLIF_V2_LIGHT = "glif_v2_light";
    public static final String THEME_GLIF_V3 = "glif_v3";
    public static final String THEME_GLIF_V3_LIGHT = "glif_v3_light";

    public static Intent getNextIntent(Intent originalIntent, int resultCode) {
        return WizardManagerHelper.getNextIntent(originalIntent, resultCode, null);
    }

    public static Intent getNextIntent(Intent originalIntent, int resultCode, Intent data) {
        Intent intent = new Intent(ACTION_NEXT);
        WizardManagerHelper.copyWizardManagerExtras(originalIntent, intent);
        intent.putExtra(EXTRA_RESULT_CODE, resultCode);
        if (data != null && data.getExtras() != null) {
            intent.putExtras(data.getExtras());
        }
        intent.putExtra(EXTRA_THEME, originalIntent.getStringExtra(EXTRA_THEME));
        return intent;
    }

    public static void copyWizardManagerExtras(Intent srcIntent, Intent dstIntent) {
        dstIntent.putExtra(EXTRA_WIZARD_BUNDLE, srcIntent.getBundleExtra(EXTRA_WIZARD_BUNDLE));
        for (String key : Arrays.asList(EXTRA_IS_FIRST_RUN, EXTRA_IS_DEFERRED_SETUP, EXTRA_IS_PRE_DEFERRED_SETUP)) {
            dstIntent.putExtra(key, srcIntent.getBooleanExtra(key, false));
        }
        for (String key : Arrays.asList(EXTRA_THEME, EXTRA_SCRIPT_URI, EXTRA_ACTION_ID)) {
            dstIntent.putExtra(key, srcIntent.getStringExtra(key));
        }
    }

    public static boolean isSetupWizardIntent(Intent intent) {
        return intent.getBooleanExtra(EXTRA_IS_FIRST_RUN, false);
    }

    public static boolean isUserSetupComplete(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)SETTINGS_SECURE_USER_SETUP_COMPLETE, (int)0) == 1;
        }
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)SETTINGS_GLOBAL_DEVICE_PROVISIONED, (int)0) == 1;
    }

    public static boolean isDeviceProvisioned(Context context) {
        if (Build.VERSION.SDK_INT >= 17) {
            return Settings.Global.getInt((ContentResolver)context.getContentResolver(), (String)SETTINGS_GLOBAL_DEVICE_PROVISIONED, (int)0) == 1;
        }
        return Settings.Secure.getInt((ContentResolver)context.getContentResolver(), (String)SETTINGS_GLOBAL_DEVICE_PROVISIONED, (int)0) == 1;
    }

    public static boolean isDeferredSetupWizard(Intent originalIntent) {
        return originalIntent != null && originalIntent.getBooleanExtra(EXTRA_IS_DEFERRED_SETUP, false);
    }

    public static boolean isPreDeferredSetupWizard(Intent originalIntent) {
        return originalIntent != null && originalIntent.getBooleanExtra(EXTRA_IS_PRE_DEFERRED_SETUP, false);
    }

    public static boolean isLightTheme(Intent intent, boolean def) {
        String theme = intent.getStringExtra(EXTRA_THEME);
        return WizardManagerHelper.isLightTheme(theme, def);
    }

    public static boolean isLightTheme(String theme, boolean def) {
        if (THEME_HOLO_LIGHT.equals(theme) || THEME_MATERIAL_LIGHT.equals(theme) || THEME_GLIF_LIGHT.equals(theme) || THEME_GLIF_V2_LIGHT.equals(theme) || THEME_GLIF_V3_LIGHT.equals(theme)) {
            return true;
        }
        if (THEME_HOLO.equals(theme) || THEME_MATERIAL.equals(theme) || THEME_GLIF.equals(theme) || THEME_GLIF_V2.equals(theme) || THEME_GLIF_V3.equals(theme)) {
            return false;
        }
        return def;
    }

    @StyleRes
    public static int getThemeRes(Intent intent, @StyleRes int defaultTheme) {
        String theme = intent.getStringExtra(EXTRA_THEME);
        return WizardManagerHelper.getThemeRes(theme, defaultTheme);
    }

    @StyleRes
    public static int getThemeRes(String theme, @StyleRes int defaultTheme) {
        if (theme != null) {
            switch (theme) {
                case "glif_v3_light": {
                    return R.style.SuwThemeGlifV3_Light;
                }
                case "glif_v3": {
                    return R.style.SuwThemeGlifV3;
                }
                case "glif_v2_light": {
                    return R.style.SuwThemeGlifV2_Light;
                }
                case "glif_v2": {
                    return R.style.SuwThemeGlifV2;
                }
                case "glif_light": {
                    return R.style.SuwThemeGlif_Light;
                }
                case "glif": {
                    return R.style.SuwThemeGlif;
                }
                case "material_light": {
                    return R.style.SuwThemeMaterial_Light;
                }
                case "material": {
                    return R.style.SuwThemeMaterial;
                }
            }
        }
        return defaultTheme;
    }
}

